/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.crsh.command.CommandInvoker;
import org.crsh.command.ShellCommand;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.ResourceKind;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.impl.CommandContextImpl;
import org.crsh.shell.impl.CommandExecution;
import org.crsh.shell.impl.CreateCommandException;
import org.crsh.shell.impl.GroovyScriptCommand;
import org.crsh.shell.impl.Parser;
import org.crsh.util.TimestampedObject;
import org.crsh.util.Utils;
import org.crsh.vfs.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRaSH
implements Shell {
    static final Logger log = LoggerFactory.getLogger(CRaSH.class);
    private final GroovyShell groovyShell;
    private final PluginContext context;
    private final Map<String, TimestampedObject<Class<? extends ShellCommand>>> commands;
    final Map<String, Object> attributes;

    public ShellCommand getCommand(String name) throws CreateCommandException, NullPointerException {
        if (name == null) {
            throw new NullPointerException("No null argument alloed");
        }
        TimestampedObject<Class<? extends ShellCommand>> providerRef = this.commands.get(name);
        Resource script = this.context.loadResource(name, ResourceKind.SCRIPT);
        if (script != null) {
            if (providerRef != null && script.getTimestamp() != providerRef.getTimestamp()) {
                providerRef = null;
            }
            if (providerRef == null) {
                Class clazz;
                try {
                    clazz = this.groovyShell.getClassLoader().parseClass(script.getContent(), name);
                }
                catch (CompilationFailedException e) {
                    throw new CreateCommandException("Could not compile command script", e);
                }
                if (ShellCommand.class.isAssignableFrom(clazz)) {
                    Class<ShellCommand> providerClass = clazz.asSubclass(ShellCommand.class);
                    providerRef = new TimestampedObject<Class<ShellCommand>>(script.getTimestamp(), providerClass);
                    this.commands.put(name, providerRef);
                } else {
                    throw new CreateCommandException("Parsed script " + clazz.getName() + " does not implements " + CommandInvoker.class.getName());
                }
            }
        }
        if (providerRef == null) {
            return null;
        }
        try {
            return providerRef.getObject().newInstance();
        }
        catch (Exception e) {
            throw new CreateCommandException("Could not create command " + providerRef.getObject().getName() + " instance", e);
        }
    }

    public GroovyShell getGroovyShell() {
        return this.groovyShell;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public CRaSH(PluginContext context) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("shellContext", context);
        attributes.put("shell", this);
        CompilerConfiguration config = new CompilerConfiguration();
        config.setRecompileGroovySource(true);
        config.setScriptBaseClass(GroovyScriptCommand.class.getName());
        GroovyShell groovyShell = new GroovyShell(context.getLoader(), new Binding(attributes), config);
        String script = context.loadResource("login", ResourceKind.LIFECYCLE).getContent();
        groovyShell.evaluate(script, "login");
        this.attributes = attributes;
        this.groovyShell = groovyShell;
        this.commands = new ConcurrentHashMap<String, TimestampedObject<Class<? extends ShellCommand>>>();
        this.context = context;
    }

    public void close() {
        String script = this.context.loadResource("logout", ResourceKind.LIFECYCLE).getContent();
        this.groovyShell.evaluate(script, "logout");
    }

    @Override
    public String getWelcome() {
        return this.groovyShell.evaluate("welcome();").toString();
    }

    @Override
    public String getPrompt() {
        return (String)this.groovyShell.evaluate("prompt();");
    }

    @Override
    public void process(String request, ShellProcessContext processContext) {
        if (processContext == null) {
            throw new NullPointerException();
        }
        log.debug("Invoking request " + request);
        CommandExecution cmdExe = new CommandExecution(this, request, processContext);
        cmdExe.execute();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Map<String, String> complete(String prefix) {
        CRaSH.log.debug("Want prefix of " + prefix);
        ast = new Parser(prefix).parse();
        if (ast != null) {
            last = ast.lastTerm();
            termPrefix = Utils.trimLeft(last.getLine());
        } else {
            termPrefix = "";
        }
        CRaSH.log.debug("Retained term prefix is " + prefix);
        completions = Collections.emptyMap();
        pos = termPrefix.indexOf(32);
        if (pos == -1) {
            completions = new HashMap<K, V>();
            for (String resourceId : this.context.listResourceId(ResourceKind.SCRIPT)) {
                if (!resourceId.startsWith(termPrefix)) continue;
                completions.put(resourceId.substring(termPrefix.length()), " ");
            }
        } else {
            commandName = termPrefix.substring(0, pos);
            termPrefix = termPrefix.substring(pos);
            try {
                command = this.getCommand(commandName);
                if (command == null) ** GOTO lbl28
                completions = command.complete(new CommandContextImpl(this.attributes), termPrefix);
            }
            catch (CreateCommandException e) {
                CRaSH.log.debug("Could not create command for completion of " + prefix, (Throwable)e);
            }
        }
lbl28:
        // 4 sources

        CRaSH.log.debug("Found completions for " + prefix + ": " + completions);
        return completions;
    }
}

