/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.vfs.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluginLifeCycle {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private PluginContext context;

    public PluginContext getContext() {
        return this.context;
    }

    public final void start(PluginContext context) {
        this.context = context;
        Properties props = new Properties();
        Resource res = context.loadResource("crash.properties", ResourceKind.CONFIG);
        if (res != null) {
            try {
                URL url = res.getURL();
                InputStream in = url.openStream();
                props.load(in);
                this.log.debug("Loaded properties from " + url + " " + props);
            }
            catch (IOException e) {
                this.log.warn("Could not configure from crash.properties", (Throwable)e);
            }
        } else {
            this.log.debug("Could not find crash.properties file");
        }
        props.putAll((Map<?, ?>)System.getProperties());
        for (PropertyDescriptor<?> desc : PropertyDescriptor.ALL.values()) {
            String key = "crash." + desc.name;
            String value = props.getProperty(key);
            if (value == null) continue;
            try {
                this.log.info("Configuring property " + desc.name + "=" + value + " from properties");
                context.setProperty(desc, value);
            }
            catch (IllegalArgumentException e) {
                this.log.error("Could not configure property", (Throwable)e);
            }
        }
        context.start();
    }

    public final void stop() {
        this.context.stop();
    }
}

