/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import groovy.lang.GroovyShell;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.crsh.TestPluginContext;
import org.crsh.plugin.PluginContext;
import org.crsh.shell.ShellFactory;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.CRaSH;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommandTestCase
extends TestCase {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected CRaSH shell;
    protected GroovyShell groovyShell;

    protected AbstractCommandTestCase() {
    }

    protected AbstractCommandTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ShellFactory builder = new ShellFactory((PluginContext)new TestPluginContext());
        this.shell = builder.build();
        this.groovyShell = this.shell.getGroovyShell();
    }

    protected void tearDown() throws Exception {
        if (this.shell != null) {
            this.shell.close();
            this.shell = null;
            this.groovyShell = null;
        }
    }

    protected final ShellResponse evaluate(String s) {
        final AtomicReference resp = new AtomicReference();
        ShellProcessContext ctx = new ShellProcessContext(){

            public int getWidth() {
                return 32;
            }

            public String getProperty(String name) {
                return null;
            }

            public void begin(ShellProcess process) {
            }

            public String readLine(String msg, boolean echo) {
                throw new UnsupportedOperationException("The command does not have access to console line reading");
            }

            public void end(ShellResponse response) {
                resp.set(response);
            }
        };
        ShellProcess process = this.shell.createProcess(s);
        process.execute(ctx);
        return (ShellResponse)resp.get();
    }

    protected final void assertUnknownCommand(String s) {
        ShellResponse resp = this.evaluate(s);
        AbstractCommandTestCase.assertTrue((String)("Was expecting an ok response instead of " + resp), (boolean)(resp instanceof ShellResponse.UnknownCommand));
        AbstractCommandTestCase.assertEquals((String)s, (String)((ShellResponse.UnknownCommand)resp).getName());
    }

    protected final void assertError(String s, Class<? extends Throwable> expectedErrorType) {
        Throwable error = this.assertError(s);
        if (!expectedErrorType.isInstance(error)) {
            AbstractCommandTestCase.fail((String)("Expected error " + error + " to be of type " + expectedErrorType.getName()));
        }
    }

    protected final Throwable assertError(String s) {
        ShellResponse resp = this.evaluate(s);
        AbstractCommandTestCase.assertTrue((String)("Was expecting an ok response instead of " + resp), (boolean)(resp instanceof ShellResponse.Error));
        return ((ShellResponse.Error)resp).getThrowable();
    }

    protected final ShellResponse.Display assertOk(String expected, String s) {
        ShellResponse.Ok ok = this.assertOk(s);
        AbstractCommandTestCase.assertTrue((String)("Was not expecting response to be " + ok), (boolean)(ok instanceof ShellResponse.Display));
        ShellResponse.Display display = (ShellResponse.Display)ok;
        AbstractCommandTestCase.assertEquals((String)expected, (String)display.getText());
        return display;
    }

    protected final ShellResponse.Ok assertOk(String s) {
        ShellResponse resp = this.evaluate(s);
        if (resp instanceof ShellResponse.Ok) {
            return (ShellResponse.Ok)resp;
        }
        if (resp instanceof ShellResponse.Error) {
            ShellResponse.Error err = (ShellResponse.Error)resp;
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause(err.getThrowable());
            throw afe;
        }
        throw new AssertionFailedError("Was expecting an ok response instead of " + resp);
    }
}

