/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.concurrent;

import java.io.Closeable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import org.crsh.shell.Shell;
import org.crsh.shell.concurrent.AsyncProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncShell
implements Shell,
Closeable {
    final Shell shell;
    private AsyncProcess current;
    final CompletionService<AsyncProcess> executor;
    boolean closed;
    final Object lock = new Object();
    final Set<AsyncProcess> processes;

    public AsyncShell(Executor executor, Shell shell) {
        this.shell = shell;
        this.current = null;
        this.executor = new ExecutorCompletionService<AsyncProcess>(executor);
        this.closed = false;
        this.processes = Collections.synchronizedSet(new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        AsyncProcess[] toCancel = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                toCancel = null;
            } else {
                this.closed = true;
                toCancel = this.processes.toArray(new AsyncProcess[this.processes.size()]);
            }
        }
        if (toCancel != null) {
            for (AsyncProcess process : toCancel) {
                process.cancel();
            }
        }
    }

    @Override
    public String getWelcome() {
        return this.shell.getWelcome();
    }

    @Override
    public String getPrompt() {
        return this.shell.getPrompt();
    }

    @Override
    public Map<String, String> complete(String prefix) {
        return this.shell.complete(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncProcess createProcess(String request) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException();
            }
        }
        return new AsyncProcess(this, request);
    }
}

