/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.spi.jline;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jline.ConsoleReader;
import org.crsh.term.CodeType;
import org.crsh.term.spi.TermIO;

public class JLineIO
implements TermIO {
    private final ConsoleReader reader;
    private final short[] keyBindings;
    private StringBuffer buffer = new StringBuffer();

    public JLineIO() throws Exception {
        ConsoleReader reader = new ConsoleReader();
        Method method = ConsoleReader.class.getDeclaredMethod("getKeyForAction", Short.TYPE);
        method.setAccessible(true);
        Field f = ConsoleReader.class.getDeclaredField("keybindings");
        f.setAccessible(true);
        short[] keyBindings = (short[])f.get(reader);
        this.reader = reader;
        this.keyBindings = keyBindings;
    }

    public int read() throws IOException {
        int i = this.reader.readVirtualKey();
        return i;
    }

    public int getWidth() {
        return this.reader.getTermwidth();
    }

    public String getProperty(String name) {
        return null;
    }

    public CodeType decode(int code) {
        short action = this.keyBindings[code];
        switch (action) {
            case -58: {
                return CodeType.TAB;
            }
            case -41: {
                return CodeType.BACKSPACE;
            }
            case -4: {
                return CodeType.LEFT;
            }
            case -19: {
                return CodeType.RIGHT;
            }
            case -59: {
                return CodeType.CLOSE;
            }
            case -11: {
                return CodeType.UP;
            }
            case -9: {
                return CodeType.DOWN;
            }
        }
        return CodeType.CHAR;
    }

    public void close() {
    }

    public void flush() throws IOException {
        System.out.print(this.buffer);
        this.buffer.setLength(0);
    }

    public void write(String s) throws IOException {
        this.buffer.append(s);
    }

    public void write(char c) throws IOException {
        this.buffer.append(c);
    }

    public void writeDel() throws IOException {
        this.buffer.append("\b \b");
    }

    public void writeCRLF() throws IOException {
        this.buffer.append("\n");
    }

    public boolean moveRight(char c) throws IOException {
        this.buffer.append(c);
        return true;
    }

    public boolean moveLeft() throws IOException {
        this.buffer.append("\b");
        return true;
    }
}

