/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.standalone;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginLifeCycle;
import org.crsh.plugin.ServiceLoaderDiscovery;
import org.crsh.util.Utils;
import org.crsh.vfs.FS;
import org.crsh.vfs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap
extends PluginLifeCycle {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private List<File> mounts = Utils.newArrayList();
    private List<File> classPath = Utils.newArrayList();
    private ClassLoader baseLoader;

    public Bootstrap(ClassLoader baseLoader) throws NullPointerException {
        if (baseLoader == null) {
            throw new NullPointerException("No null base loader accepted");
        }
        this.baseLoader = baseLoader;
    }

    public Bootstrap addToMounts(File file) {
        this.mounts.add(file);
        return this;
    }

    public Bootstrap addToClassPath(File file) {
        this.classPath.add(file);
        return this;
    }

    public void bootstrap() throws Exception {
        URL[] urls = new URL[this.classPath.size()];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = this.classPath.get(i).toURI().toURL();
        }
        URLClassLoader classLoader = new URLClassLoader(urls, this.baseLoader);
        FS fs = new FS();
        for (File file : this.mounts) {
            fs.mount(file);
        }
        fs.mount(classLoader, Path.get("/crash/"));
        ServiceLoaderDiscovery discovery = new ServiceLoaderDiscovery(classLoader);
        StringBuilder info = new StringBuilder("Booting crash with classpath=");
        info.append(this.classPath).append(" and mounts=[");
        for (int i = 0; i < this.mounts.size(); ++i) {
            if (i > 0) {
                info.append(',');
            }
            info.append(this.mounts.get(i).getAbsolutePath());
        }
        info.append(']');
        this.log.info(info.toString());
        PluginContext context = new PluginContext(discovery, fs, classLoader);
        context.refresh();
        this.start(context);
    }

    public void shutdown() {
        this.stop();
    }
}

