/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.processor;

import java.util.LinkedList;
import java.util.concurrent.Callable;
import org.crsh.AbstractTestCase;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncShell
implements Shell {
    private final LinkedList<Throwable> failures;
    private final Object lock = new Object();
    private final LinkedList<ShellProcess> queue = new LinkedList();

    public SyncShell() {
        this.failures = new LinkedList();
    }

    public <R extends ShellResponse> void publish(final Callable<R> callable) {
        this.publish(new ShellProcess(){

            public void execute(ShellProcessContext processContext) {
                try {
                    ShellResponse response = (ShellResponse)callable.call();
                    processContext.end(response);
                }
                catch (Exception e) {
                    throw AbstractTestCase.failure(e);
                }
            }

            public void cancel() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(ShellProcess process) {
        Object object = this.lock;
        synchronized (object) {
            this.queue.add(process);
            this.lock.notifyAll();
        }
    }

    public String getWelcome() {
        return "welcome";
    }

    public String getPrompt() {
        return "%";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ShellProcess createProcess(String request) throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            while (this.queue.size() <= 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw AbstractTestCase.failure(e);
                }
            }
            return this.queue.removeFirst();
        }
    }

    public CommandCompletion complete(String prefix) {
        throw new UnsupportedOperationException();
    }
}

