/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs;

import java.io.IOException;
import org.crsh.vfs.Handle;
import org.crsh.vfs.Path;
import org.crsh.vfs.spi.FSDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Mount<H> {
    private final FSDriver<H> driver;

    static <H> Mount<H> wrap(FSDriver<H> driver) {
        return new Mount<H>(driver);
    }

    Mount(FSDriver<H> driver) {
        this.driver = driver;
    }

    Handle<H> getHandle(Path path) throws IOException {
        H current = this.driver.root();
        for (String name : path) {
            Object next = null;
            for (H child : this.driver.children(current)) {
                String childName = this.driver.name(child);
                if (!childName.equals(name)) continue;
                next = child;
                break;
            }
            if (next == null) {
                return null;
            }
            current = next;
        }
        if (path.isDir() == this.driver.isDir(current)) {
            return new Handle<H>(this.driver, current);
        }
        return null;
    }
}

