/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.util.concurrent.CountDownLatch;
import org.crsh.AbstractTestCase;
import org.crsh.BaseProcessContext;
import org.crsh.shell.AbstractCommandTestCase;
import org.crsh.shell.ShellResponse;

public class CancelTestCase
extends AbstractCommandTestCase {
    private static final Object interrupLock = new Object();
    private static boolean interruptDoCancel = false;
    private static boolean interruptInterrupted = false;
    private static CountDownLatch loopLatch1;
    private static volatile boolean loopLatch2;
    private static volatile Boolean loopInterrupted;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void interruptCallback() {
        Object object = interrupLock;
        synchronized (object) {
            interruptDoCancel = true;
            interrupLock.notifyAll();
            try {
                interrupLock.wait(10000L);
            }
            catch (InterruptedException e) {
                interruptInterrupted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInterrupt() {
        final BaseProcessContext ctx = this.create("invoke " + CancelTestCase.class.getName() + " interruptCallback");
        Thread t = new Thread(){

            public void run() {
                ctx.execute();
            }
        };
        t.start();
        Object object = interrupLock;
        synchronized (object) {
            if (!interruptDoCancel) {
                try {
                    interrupLock.wait(10000L);
                }
                catch (InterruptedException e) {
                    throw AbstractTestCase.failure(e);
                }
            }
        }
        CancelTestCase.assertTrue((boolean)interruptDoCancel);
        ctx.cancel();
        ShellResponse resp = ctx.getResponse();
        CancelTestCase.assertEquals(ShellResponse.Cancelled.class, resp.getClass());
        CancelTestCase.assertTrue((boolean)interruptInterrupted);
    }

    public void testLoop() throws Exception {
        final BaseProcessContext ctx = this.create("invoke " + CancelTestCase.class.getName() + " loopCallback");
        Thread t = new Thread(){

            public void run() {
                ctx.execute();
            }
        };
        loopLatch1 = new CountDownLatch(1);
        loopLatch2 = true;
        loopInterrupted = null;
        t.start();
        loopLatch1.await();
        ctx.cancel();
        loopLatch2 = false;
        ShellResponse resp = ctx.getResponse();
        CancelTestCase.assertEquals(ShellResponse.Cancelled.class, resp.getClass());
        CancelTestCase.assertEquals((Object)Boolean.TRUE, (Object)loopInterrupted);
    }

    public static void loopCallback() {
        loopLatch1.countDown();
        while (loopLatch2) {
        }
        loopInterrupted = Thread.currentThread().isInterrupted();
    }
}

