/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.console;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.crsh.term.console.ViewWriter;

public class TestClientOutput
extends ViewWriter {
    private final StringBuilder line = new StringBuilder();
    private int lastPosition = 0;
    private int position = 0;
    private final boolean supportsCursorMove;

    public TestClientOutput(boolean supportsCursorMove) {
        this.supportsCursorMove = supportsCursorMove;
    }

    public void assertChars(String s) {
        Assert.assertTrue((this.line.length() >= s.length() ? 1 : 0) != 0);
        Assert.assertEquals((String)s, (String)this.line.substring(0, s.length()));
        this.line.delete(0, s.length());
    }

    public void assertEmpty() {
        Assert.assertEquals((String)("Was expecting empty line instead of '" + this.line + "'"), (int)0, (int)this.line.length());
    }

    protected void flush() throws IOException {
    }

    protected void write(CharSequence s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.write(c);
        }
    }

    protected void write(char c) throws IOException {
        if (c == '\r' || c == '\n') {
            throw new AssertionFailedError();
        }
        if (this.position < this.line.length()) {
            this.line.setCharAt(this.position++, c);
        } else {
            this.line.append(c);
            ++this.position;
        }
    }

    protected void writeDel() throws IOException {
        if (this.position <= this.lastPosition) {
            throw new AssertionFailedError();
        }
        this.line.deleteCharAt(--this.position);
    }

    protected boolean writeMoveRight(char c) {
        if (this.supportsCursorMove) {
            ++this.position;
            return true;
        }
        return false;
    }

    protected void writeCRLF() throws IOException {
        this.line.append("\r\n");
        this.position += 2;
        this.lastPosition = this.position;
    }

    protected boolean writeMoveLeft() {
        if (this.supportsCursorMove) {
            if (this.position > this.lastPosition) {
                --this.position;
            } else {
                throw new AssertionFailedError();
            }
            return true;
        }
        return false;
    }
}

