/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;
import org.crsh.util.TypeResolver;

public class TypeResolverTestCase
extends TestCase {
    public void testFoo() {
        Type resolved = TypeResolver.resolve(ThreadLocal.class, ThreadLocal.class, (int)0);
        TypeResolverTestCase.assertTrue((boolean)(resolved instanceof TypeVariable));
        TypeVariable tv = (TypeVariable)resolved;
        TypeResolverTestCase.assertEquals(ThreadLocal.class, tv.getGenericDeclaration());
        TypeResolverTestCase.assertEquals(Object.class, (Object)TypeResolver.resolveToClass(ThreadLocal.class, ThreadLocal.class, (int)0));
    }

    public void testBar() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A
        extends ThreadLocal<String> {
            A() {
            }
        }
        Type resolved = TypeResolver.resolve(A.class, ThreadLocal.class, (int)0);
        TypeResolverTestCase.assertEquals(String.class, (Object)resolved);
        TypeResolverTestCase.assertEquals(String.class, (Object)TypeResolver.resolveToClass(A.class, ThreadLocal.class, (int)0));
    }

    public void testZoo() {
        class A
        extends ThreadLocal {
            A() {
            }
        }
        TypeVariable resolved = (TypeVariable)TypeResolver.resolve(A.class, ThreadLocal.class, (int)0);
        TypeResolverTestCase.assertEquals((String)"T", (String)resolved.getName());
        TypeResolverTestCase.assertEquals(Collections.singletonList(Object.class), Arrays.asList(resolved.getBounds()));
        TypeResolverTestCase.assertEquals(Object.class, (Object)TypeResolver.resolveToClass(A.class, ThreadLocal.class, (int)0));
    }

    public void testJuu() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A
        extends InheritableThreadLocal<String> {
            A() {
            }
        }
        Type resolved = TypeResolver.resolve(A.class, ThreadLocal.class, (int)0);
        TypeResolverTestCase.assertEquals(String.class, (Object)resolved);
        TypeResolverTestCase.assertEquals(String.class, (Object)TypeResolver.resolveToClass(A.class, ThreadLocal.class, (int)0));
    }

    public void testDaa() {
        Type resolved = TypeResolver.resolve(InheritableThreadLocal.class, ThreadLocal.class, (int)0);
        TypeResolverTestCase.assertTrue((boolean)(resolved instanceof TypeVariable));
        TypeVariable tv = (TypeVariable)resolved;
        TypeResolverTestCase.assertEquals(InheritableThreadLocal.class, tv.getGenericDeclaration());
        TypeResolverTestCase.assertEquals(Object.class, (Object)TypeResolver.resolveToClass(InheritableThreadLocal.class, ThreadLocal.class, (int)0));
    }
}

