/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import groovy.lang.GroovyShell;
import junit.framework.AssertionFailedError;
import org.crsh.AbstractTestCase;
import org.crsh.BaseProcessContext;
import org.crsh.TestPluginLifeCycle;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.shell.ErrorType;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.command.CRaSHSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommandTestCase
extends AbstractTestCase {
    private final CRaSHPlugin[] NO_PLUGINS = new CRaSHPlugin[0];
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected CRaSHSession shell;
    protected GroovyShell groovyShell;
    protected TestPluginLifeCycle lifeCycle;

    protected AbstractCommandTestCase() {
    }

    protected AbstractCommandTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestPluginLifeCycle lifeCycle = new TestPluginLifeCycle(this.NO_PLUGINS);
        lifeCycle.start();
        this.shell = lifeCycle.createShell();
        this.groovyShell = this.shell.getGroovyShell();
        this.lifeCycle = lifeCycle;
    }

    protected void tearDown() throws Exception {
        if (this.shell != null) {
            this.shell.close();
            this.shell = null;
            this.groovyShell = null;
        }
    }

    protected final BaseProcessContext create(String s) {
        return BaseProcessContext.create((Shell)this.shell, s);
    }

    protected final BaseProcessContext execute(String s) {
        return this.create(s).execute();
    }

    protected final ShellResponse evaluate(String s) {
        return this.execute(s).getResponse();
    }

    protected final void assertUnknownCommand(String s) {
        ShellResponse resp = this.evaluate(s);
        AbstractCommandTestCase.assertTrue((String)("Was expecting an ok response instead of " + resp), (boolean)(resp instanceof ShellResponse.UnknownCommand));
        AbstractCommandTestCase.assertEquals((String)s, (String)((ShellResponse.UnknownCommand)resp).getName());
    }

    protected final void assertEvalError(String s, Class<? extends Throwable> expectedThrowableType) {
        Throwable error = this.assertEvalError(s);
        AbstractCommandTestCase.assertType(expectedThrowableType, error);
    }

    protected final Throwable assertEvalError(String s) {
        return this.assertError(s, ErrorType.EVALUATION);
    }

    protected final void assertInternalError(String s, Class<? extends Throwable> expectedThrowableType) {
        Throwable error = this.assertInternalError(s);
        AbstractCommandTestCase.assertType(expectedThrowableType, error);
    }

    protected final Throwable assertInternalError(String s) {
        return this.assertError(s, ErrorType.INTERNAL);
    }

    protected final void assertError(String s, ErrorType expectedErrorType, Class<? extends Throwable> expectedThrowableType) {
        Throwable error = this.assertError(s, expectedErrorType);
        AbstractCommandTestCase.assertType(expectedThrowableType, error);
    }

    protected final Throwable assertError(String s, ErrorType expectedErrorType) {
        ShellResponse resp = this.evaluate(s);
        ShellResponse.Error error = AbstractCommandTestCase.assertInstance(ShellResponse.Error.class, resp);
        AbstractCommandTestCase.assertEquals((Object)expectedErrorType, (Object)error.getType());
        return error.getThrowable();
    }

    protected final ShellResponse.Display assertDisplay(String expected, String s) {
        ShellResponse.Ok ok = this.assertOk(s);
        AbstractCommandTestCase.assertTrue((String)("Was not expecting response to be " + ok), (boolean)(ok instanceof ShellResponse.Display));
        AbstractCommandTestCase.assertEquals((String)expected, (String)ok.getText());
        return (ShellResponse.Display)ok;
    }

    protected final ShellResponse.Ok assertOk(String expected, String s) {
        ShellResponse.Ok ok = this.assertOk(s);
        AbstractCommandTestCase.assertEquals((String)expected, (String)ok.getText());
        return ok;
    }

    protected final ShellResponse.Ok assertOk(String s) {
        ShellResponse resp = this.evaluate(s);
        if (resp instanceof ShellResponse.Ok) {
            return (ShellResponse.Ok)resp;
        }
        if (resp instanceof ShellResponse.Error) {
            ShellResponse.Error err = (ShellResponse.Error)resp;
            AssertionFailedError afe = new AssertionFailedError();
            afe.initCause(err.getThrowable());
            throw afe;
        }
        throw new AssertionFailedError("Was expecting an ok response instead of " + resp);
    }
}

