/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Tuple;
import java.io.IOException;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.crsh.cmdline.Delimiter;
import org.crsh.command.CommandClosure;
import org.crsh.command.CommandInvoker;
import org.crsh.command.InnerInvocationContext;
import org.crsh.command.InvocationContext;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;

final class CommandDispatcher
extends Closure {
    final InvocationContext ic;
    final ShellCommand command;

    CommandDispatcher(ShellCommand command, InvocationContext ic) {
        super(new Object());
        this.command = command;
        this.ic = ic;
    }

    public Object getProperty(String property) {
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            return new CommandClosure(this, property);
        }
    }

    public Object invokeMethod(String name, Object args) {
        try {
            return super.invokeMethod(name, args);
        }
        catch (MissingMethodException e) {
            return this.dispatch(name, args);
        }
    }

    public Object call(Object[] arguments) {
        return this.dispatch("", arguments);
    }

    Object dispatch(String methodName, Object arguments) {
        if (arguments == null) {
            return this.dispatch(methodName, MetaClassHelper.EMPTY_ARRAY);
        }
        if (arguments instanceof Tuple) {
            Tuple tuple = (Tuple)arguments;
            return this.dispatch(methodName, tuple.toArray());
        }
        if (arguments instanceof Object[]) {
            return this.dispatch(methodName, (Object[])arguments);
        }
        return this.dispatch(methodName, new Object[]{arguments});
    }

    Object dispatch(String name, Object[] args) {
        int to;
        StringBuilder line = new StringBuilder();
        if (name.length() > 0) {
            line.append(name).append(" ");
        }
        Closure closure = (to = args.length) > 0 && args[to - 1] instanceof Closure ? (Closure)args[--to] : null;
        if (to > 0) {
            Object first = args[0];
            try {
                int from;
                if (first instanceof Map) {
                    from = 1;
                    Map options = (Map)first;
                    for (Map.Entry option : options.entrySet()) {
                        boolean printValue;
                        boolean printName;
                        String optionName = option.getKey().toString();
                        Object optionValue = option.getValue();
                        if (optionValue instanceof Boolean) {
                            printName = Boolean.TRUE.equals(optionValue);
                            printValue = false;
                        } else {
                            printName = true;
                            printValue = true;
                        }
                        if (!printName) continue;
                        line.append(" ");
                        line.append(optionName.length() == 1 ? "-" : "--");
                        line.append(optionName);
                        if (!printValue) continue;
                        line.append(" ");
                        line.append("\"");
                        Delimiter.DOUBLE_QUOTE.escape((CharSequence)optionValue.toString(), (Appendable)line);
                        line.append("\"");
                    }
                } else {
                    from = 0;
                }
                while (from < to) {
                    Object o = args[from++];
                    line.append(" ");
                    line.append("\"");
                    Delimiter.DOUBLE_QUOTE.escape((CharSequence)o.toString(), (Appendable)line);
                    line.append("\"");
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        try {
            CommandInvoker<?, ?> invoker = this.command.createInvoker(line.toString());
            Class<?> producedType = invoker.getProducedType();
            InnerInvocationContext inc = new InnerInvocationContext(this.ic, producedType, closure != null);
            invoker.invoke(inc);
            if (closure != null) {
                for (Map.Entry o : inc.products) {
                    closure.call(o);
                }
            }
            return null;
        }
        catch (ScriptException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                throw new InvokerInvocationException(cause);
            }
            throw e;
        }
    }
}

