/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.io.Serializable;
import java.util.Collections;
import org.crsh.shell.ErrorType;
import org.crsh.text.CharReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ShellResponse
implements Serializable {
    public static UnknownCommand unknownCommand(String name) {
        return new UnknownCommand(name);
    }

    public static NoCommand noCommand() {
        return NoCommand.INSTANCE;
    }

    public static Ok ok(Iterable<?> produced) {
        return new Ok(produced);
    }

    public static Ok ok() {
        return new Ok();
    }

    public static Display display(String text) {
        return new Display(new CharReader(text));
    }

    public static Display display(CharReader reader) {
        return new Display(reader);
    }

    public static Display display(Iterable<?> produced, CharReader reader) {
        return new Display(produced, reader);
    }

    public static Error evalError(String msg, Throwable throwable) {
        return new Error(ErrorType.EVALUATION, msg, throwable);
    }

    public static Error evalError(String msg) {
        return new Error(ErrorType.EVALUATION, msg);
    }

    public static Error internalError(String msg, Throwable throwable) {
        return new Error(ErrorType.INTERNAL, msg, throwable);
    }

    public static Error internalError(String msg) {
        return new Error(ErrorType.INTERNAL, msg);
    }

    public static Error error(ErrorType type, String msg, Throwable throwable) {
        return new Error(type, msg, throwable);
    }

    public static Error error(ErrorType type, String msg) {
        return new Error(type, msg);
    }

    public static Cancelled cancelled() {
        return Cancelled.INSTANCE;
    }

    public static Close close() {
        return Close.INSTANCE;
    }

    public abstract CharReader getReader();

    public static class Error
    extends ShellResponse {
        private final ErrorType type;
        private final Throwable throwable;
        private final String msg;

        private Error(ErrorType type, String msg) {
            this.type = type;
            this.msg = msg;
            this.throwable = null;
        }

        private Error(ErrorType type, String msg, Throwable throwable) {
            this.type = type;
            this.msg = msg;
            this.throwable = throwable;
        }

        public ErrorType getType() {
            return this.type;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public CharReader getReader() {
            return new CharReader(this.msg);
        }

        public String toString() {
            return "ShellResponse.Error[type=" + (Object)((Object)this.type) + ",msg=" + this.msg + "]";
        }
    }

    public static class Cancelled
    extends ShellResponse {
        private static final Cancelled INSTANCE = new Cancelled();

        private Cancelled() {
        }

        public CharReader getReader() {
            return new CharReader("cancelled");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Display
    extends Ok {
        private final CharReader reader;

        private Display(CharReader reader) {
            this.reader = reader;
        }

        private Display(Iterable<?> produced, CharReader reader) {
            super(produced);
            this.reader = reader;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Display) {
                Display that = (Display)obj;
                return this.reader.equals(that.reader);
            }
            return false;
        }

        @Override
        public CharReader getReader() {
            return this.reader;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Ok
    extends ShellResponse {
        private final transient Iterable<?> produced;

        private Ok() {
            this(Collections.emptyList());
        }

        private Ok(Iterable<?> produced) {
            this.produced = produced;
        }

        public Iterable<?> getProduced() {
            return this.produced;
        }

        @Override
        public CharReader getReader() {
            return new CharReader("");
        }
    }

    public static class Close
    extends ShellResponse {
        private static final Close INSTANCE = new Close();

        private Close() {
        }

        public CharReader getReader() {
            return new CharReader("Have a good day!\r\n");
        }
    }

    public static class NoCommand
    extends ShellResponse {
        private static final NoCommand INSTANCE = new NoCommand();

        private NoCommand() {
        }

        public CharReader getReader() {
            return new CharReader("Please type something");
        }
    }

    public static class UnknownCommand
    extends ShellResponse {
        private final String name;

        private UnknownCommand(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public CharReader getReader() {
            return new CharReader(this.name + ": command not found");
        }

        public String toString() {
            return "UnknownCommand[" + this.name + "]";
        }
    }
}

