/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import junit.framework.TestCase;
import org.crsh.shell.TestInvocationContext;
import org.crsh.shell.io.ShellWriter;
import org.crsh.shell.ui.Element;
import org.crsh.shell.ui.LabelElement;
import org.crsh.shell.ui.RowElement;
import org.crsh.shell.ui.TableElement;
import org.crsh.shell.ui.TreeElement;
import org.crsh.text.CharReader;
import org.crsh.text.Color;
import org.crsh.text.Decoration;

public class TableElementTestCase
extends TestCase {
    public void testSimple() throws Exception {
        TableElement tableElement = new TableElement();
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)"a     b     _c     d     _", (String)reader.toString());
    }

    public void testStyle() throws Exception {
        TableElement tableElement = new TableElement();
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.setBackground(Color.green);
        row1.setForeground(Color.blue);
        row1.setDecoration(Decoration.bold);
        LabelElement a = new LabelElement("a");
        a.setParent((Element)row1);
        LabelElement b = new LabelElement("b");
        b.setParent((Element)row1);
        row1.addValue((Element)a);
        row1.addValue((Element)b);
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        LabelElement c = new LabelElement("c");
        c.setParent((Element)row2);
        c.setBackground(Color.green);
        c.setForeground(Color.blue);
        c.setDecoration(Decoration.bold);
        row2.addValue((Element)c);
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        String expected = "\u001b[1;34;42ma     b     \u001b[0m_\u001b[1;34;42mc     \u001b[0md     \u001b[0m_";
        StringBuilder sb = new StringBuilder();
        reader.writeAnsiTo((Appendable)sb);
        String ansi = sb.toString();
        TableElementTestCase.assertEquals((String)expected, (String)ansi);
    }

    public void testInNode() throws Exception {
        TableElement tableElement = new TableElement();
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("b"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        TreeElement node = new TreeElement();
        node.addNode((Element)new LabelElement("foo"));
        node.addNode((Element)tableElement);
        node.addNode((Element)new LabelElement("bar"));
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        node.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)"+-foo_+-a     b     _| c     d     _+-bar_", (String)reader.toString());
    }

    public void testTooLarge() throws Exception {
        TableElement tableElement = new TableElement();
        RowElement row1 = new RowElement();
        row1.setParent((Element)tableElement);
        row1.addValue((Element)new LabelElement("a"));
        row1.addValue((Element)new LabelElement("This text is very ver very too large to be displayed in a cell of 32"));
        RowElement row2 = new RowElement();
        row2.setParent((Element)tableElement);
        row2.addValue((Element)new LabelElement("c"));
        row2.addValue((Element)new LabelElement("d"));
        tableElement.addRow(row1);
        tableElement.addRow(row2);
        CharReader reader = new CharReader();
        ShellWriter writer = new ShellWriter(reader, "_");
        tableElement.print(writer, new TestInvocationContext());
        TableElementTestCase.assertEquals((String)"a     This text is very ver very too large to be displayed in a cell of 32_c     d                         _", (String)reader.toString());
    }
}

