/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import groovy.lang.GroovyShell;
import junit.framework.TestCase;
import org.crsh.shell.ui.Element;
import org.crsh.shell.ui.LabelElement;
import org.crsh.shell.ui.RowElement;
import org.crsh.shell.ui.TableElement;
import org.crsh.shell.ui.TreeElement;
import org.crsh.shell.ui.UIBuilder;
import org.crsh.text.Color;
import org.crsh.text.Decoration;

public class UIBuilderTestCase
extends TestCase {
    public UIBuilderTestCase() {
    }

    public UIBuilderTestCase(String name) {
        super(name);
    }

    public void testEmptyTable() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\ndef builder = new UIBuilder();\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)0, (int)res.getElements().size());
    }

    public void testNode() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.node { };\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertNull((Object)((TreeElement)res.getElements().get(0)).getValue());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TreeElement));
        UIBuilderTestCase.assertEquals((int)0, (int)((TreeElement)res.getElements().get(0)).getSize());
    }

    public void testLabelledNode() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.node('foo') { };\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TreeElement));
        UIBuilderTestCase.assertTrue((boolean)(((TreeElement)res.getElements().get(0)).getValue() instanceof LabelElement));
        UIBuilderTestCase.assertEquals((String)"foo", (String)((LabelElement)((TreeElement)res.getElements().get(0)).getValue()).getValue());
        UIBuilderTestCase.assertEquals((int)0, (int)((TreeElement)res.getElements().get(0)).getSize());
    }

    public void testLabel() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.label('foo');\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof LabelElement));
        UIBuilderTestCase.assertEquals((String)"foo", (String)((LabelElement)res.getElements().get(0)).getValue());
    }

    public void testTable() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.table { };\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertEquals((int)0, (int)((TableElement)res.getElements().get(0)).getRows().size());
    }

    public void testEmptyRow() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.table {\nrow { }\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertEquals((int)1, (int)((TableElement)res.getElements().get(0)).getRows().size());
        UIBuilderTestCase.assertEquals((int)0, (int)((RowElement)((TableElement)res.getElements().get(0)).getRows().get(0)).getValues().size());
    }

    public void testRow() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.table {\nrow () {\nlabel(\"col1\"); label(\"col2\")\n}\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertEquals((int)1, (int)((TableElement)res.getElements().get(0)).getRows().size());
        UIBuilderTestCase.assertEquals((int)2, (int)((RowElement)((TableElement)res.getElements().get(0)).getRows().get(0)).getValues().size());
        UIBuilderTestCase.assertEquals((String)"Label[col1]", (String)((Element)((RowElement)((TableElement)res.getElements().get(0)).getRows().get(0)).getValues().get(0)).toString());
        UIBuilderTestCase.assertEquals((String)"Label[col2]", (String)((Element)((RowElement)((TableElement)res.getElements().get(0)).getRows().get(0)).getValues().get(1)).toString());
    }

    public void testRowStyleWithEnd() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\nimport org.crsh.text.Color;\nimport org.crsh.text.Decoration;\nimport org.crsh.text.Style;\ndef builder = new UIBuilder();\nbuilder.table {\nrow (decoration: bold, foreground: red, background: green) {\nlabel(\"col1\"); label(\"col2\")\n}\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertEquals((int)1, (int)((TableElement)res.getElements().get(0)).getRows().size());
        UIBuilderTestCase.assertEquals((int)2, (int)((RowElement)((TableElement)res.getElements().get(0)).getRows().get(0)).getValues().size());
        UIBuilderTestCase.assertEquals((Object)Decoration.bold, (Object)((Element)((RowElement)((TableElement)res.getElements().get(0)).getRows().get(0)).getValues().get(0)).getDecoration());
        UIBuilderTestCase.assertEquals((Object)Color.red, (Object)((Element)((RowElement)((TableElement)res.getElements().get(0)).getRows().get(0)).getValues().get(0)).getForeground());
        UIBuilderTestCase.assertEquals((Object)Color.green, (Object)((Element)((RowElement)((TableElement)res.getElements().get(0)).getRows().get(0)).getValues().get(0)).getBackground());
    }

    public void testForbiddenChild() throws Exception {
        GroovyShell shell = new GroovyShell();
        try {
            UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.shell.ui.UIBuilder;\nimport org.crsh.text.Color;\nimport org.crsh.text.Decoration;\nimport org.crsh.text.Style;\ndef builder = new UIBuilder();\nbuilder.table {\nrow() {\nnode()\n}\n};\nreturn builder;\n");
            UIBuilderTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            UIBuilderTestCase.assertEquals((String)"A table cannot contain node element", (String)iae.getMessage());
        }
    }
}

