/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.crsh.command.InvocationContext;
import org.crsh.command.impl.BaseCommandContext;
import org.crsh.shell.io.ShellPrinter;
import org.crsh.shell.io.ShellWriter;
import org.crsh.text.CharReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseInvocationContext<C, P>
extends BaseCommandContext
implements InvocationContext<C, P> {
    protected ShellPrinter writer = null;
    protected CharReader reader = null;
    protected List<P> producedItems;
    protected Iterable<C> consumedItems;

    protected BaseInvocationContext(Iterable<C> consumedItems, Map<String, Object> session, Map<String, Object> attributes) {
        super(session, attributes);
        this.consumedItems = consumedItems;
        this.producedItems = Collections.emptyList();
    }

    public List<P> getProducedItems() {
        return this.producedItems;
    }

    public CharReader getReader() {
        return this.reader;
    }

    @Override
    public boolean isPiped() {
        return this.consumedItems != null;
    }

    @Override
    public Iterable<C> consume() {
        if (this.consumedItems == null) {
            throw new IllegalStateException("Cannot consume as no pipe operation is involved");
        }
        return this.consumedItems;
    }

    @Override
    public void produce(P product) {
        if (this.producedItems.isEmpty()) {
            this.producedItems = new LinkedList<P>();
        }
        this.producedItems.add(product);
    }

    @Override
    public ShellPrinter getWriter() {
        if (this.writer == null) {
            this.reader = new CharReader();
            this.writer = new ShellPrinter(new ShellWriter(this.reader, "\r\n"), this);
        }
        return this.writer;
    }
}

