/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.remoting;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.impl.remoting.ClientMessage;
import org.crsh.shell.impl.remoting.ClientProcessContext;
import org.crsh.util.CloseableList;

public class ClientAutomaton
implements Runnable {
    final Shell shell;
    final ObjectOutputStream out;
    final ObjectInputStream in;
    ClientProcessContext current;
    final CloseableList listeners;
    Integer width;

    public ClientAutomaton(ObjectOutputStream out, ObjectInputStream in, Shell shell) {
        CloseableList listeners = new CloseableList();
        listeners.add(in);
        listeners.add(out);
        this.in = in;
        this.out = out;
        this.shell = shell;
        this.listeners = listeners;
    }

    public ClientAutomaton(InputStream in, OutputStream out, Shell shell) throws IOException {
        this(new ObjectOutputStream(out), new ObjectInputStream(in), shell);
    }

    public ClientAutomaton addCloseListener(Closeable closeable) {
        this.listeners.add(closeable);
        return this;
    }

    public void run() {
        try {
            while (!this.listeners.isClosed()) {
                ClientMessage msg = (ClientMessage)((Object)this.in.readObject());
                switch (msg) {
                    case GET_WELCOME: {
                        String welcome = this.shell.getWelcome();
                        this.out.writeObject(welcome);
                        this.out.flush();
                        break;
                    }
                    case GET_PROMPT: {
                        String prompt = this.shell.getPrompt();
                        this.out.writeObject(prompt);
                        this.out.flush();
                        break;
                    }
                    case GET_COMPLETION: {
                        String prefix = (String)this.in.readObject();
                        CommandCompletion completion = this.shell.complete(prefix);
                        this.out.writeObject(completion);
                        this.out.flush();
                        break;
                    }
                    case EXECUTE: {
                        this.width = (Integer)this.in.readObject();
                        String line = (String)this.in.readObject();
                        ShellProcess process = this.shell.createProcess(line);
                        this.current = new ClientProcessContext(this, process);
                        process.execute(this.current);
                        break;
                    }
                    case CANCEL: {
                        if (this.current == null) break;
                        this.current.process.cancel();
                        break;
                    }
                    case CLOSE: {
                        this.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void close() {
        this.listeners.close();
    }

    public int getWidth() {
        return this.width;
    }
}

