/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import java.io.IOException;
import org.crsh.shell.io.ShellWriter;
import org.crsh.shell.io.ShellWriterContext;
import org.crsh.shell.ui.Element;
import org.crsh.shell.ui.UIWriterContext;

public class LabelElement
extends Element {
    private final String value;

    public LabelElement(String value) {
        this.value = value;
    }

    public LabelElement(Object value) {
        this.value = String.valueOf(value);
    }

    public String getValue() {
        return this.value;
    }

    void doPrint(UIWriterContext ctx, ShellWriter writer) throws IOException {
        int availableWidth = ctx.getConsoleWidth() - ctx.padWidth();
        if (availableWidth < this.value.length()) {
            String remainingText = this.value;
            boolean first = true;
            while (availableWidth < remainingText.length()) {
                String currentValue = remainingText.substring(0, availableWidth).trim();
                remainingText = remainingText.substring(availableWidth).trim();
                this.printLine(ctx, writer, currentValue, availableWidth, !first);
                writer.append((ShellWriterContext)ctx, "\n");
                first = false;
            }
            ctx.rightLinePadding = "";
            this.printLine(ctx, writer, remainingText, availableWidth, !first);
        } else {
            writer.append((ShellWriterContext)ctx, this.value);
        }
    }

    private void printLine(UIWriterContext ctx, ShellWriter writer, String value, int available, boolean needed) throws IOException {
        if (needed) {
            if (ctx.parentUIContext != null) {
                ctx.parentUIContext.pad(writer);
            }
            ctx.pad(writer);
            writer.append((ShellWriterContext)ctx, ctx.leftLinePadding);
        }
        writer.append((ShellWriterContext)ctx, value);
        for (int pos = value.length(); pos < available; ++pos) {
            writer.append(" ");
        }
        writer.append((ShellWriterContext)ctx, ctx.rightLinePadding);
    }

    public String toString() {
        return "Label[" + this.value + "]";
    }

    int width() {
        return this.value.length();
    }
}

