/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.crsh.vfs.FS;
import org.crsh.vfs.Handle;
import org.crsh.vfs.Key;
import org.crsh.vfs.Mount;
import org.crsh.vfs.Path;
import org.crsh.vfs.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class File {
    private static final Logger log = LoggerFactory.getLogger(Resource.class);
    private final FS fs;
    private final Path path;
    private LinkedList<Handle<?>> handles;
    private LinkedHashMap<Key, File> children;

    public File(FS fs, Path path) {
        this.fs = fs;
        this.path = path;
        this.handles = null;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isDir() {
        return this.path.isDir();
    }

    public String getName() {
        return this.path.getName();
    }

    public Resource getResource() throws IOException {
        if (this.path.isDir()) {
            throw new IllegalStateException("Cannot get url of a dir");
        }
        Handle<?> handle = this.getHandles().peekFirst();
        return handle != null ? handle.getResource() : null;
    }

    public Iterable<Resource> getResources() throws IOException {
        if (this.path.isDir()) {
            throw new IllegalStateException("Cannot get url of a dir");
        }
        List<Resource> urls = Collections.emptyList();
        for (Handle handle : this.getHandles()) {
            if (urls.isEmpty()) {
                urls = new ArrayList<Resource>();
            }
            Resource resource = handle.getResource();
            urls.add(resource);
        }
        return urls;
    }

    public File child(String name, boolean dir) throws IOException {
        if (this.children == null) {
            this.children();
        }
        return this.children.get(new Key(name, dir));
    }

    public Iterable<File> children() throws IOException {
        if (this.children == null) {
            LinkedHashMap<Key, File> children = new LinkedHashMap<Key, File>();
            for (Handle handle : this.getHandles()) {
                for (Handle childHandle : handle.children()) {
                    File child = (File)children.get(childHandle.key);
                    if (child == null) {
                        child = new File(this.fs, Path.get(this.path, childHandle.key.name, childHandle.key.dir));
                        children.put(childHandle.key, child);
                    }
                    if (child.handles == null) {
                        child.handles = new LinkedList();
                    }
                    child.handles.add(childHandle);
                }
            }
            this.children = children;
        }
        return this.children.values();
    }

    LinkedList<Handle<?>> getHandles() {
        if (this.handles == null) {
            LinkedList handles = new LinkedList();
            for (Mount<?> mount : this.fs.mounts) {
                Handle<?> handle = null;
                try {
                    handle = mount.getHandle(this.path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (handle == null) continue;
                handles.add(handle);
            }
            this.handles = handles;
        }
        return this.handles;
    }

    public String toString() {
        return "File[path=" + this.path.getValue() + "]";
    }
}

