/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;
import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.ui.Border;
import org.crsh.text.ui.ColumnLayout;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.RowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RowRenderer
extends Renderer {
    private final List<Renderer> cols;
    private final Style.Composite style;
    private final boolean header;

    RowRenderer(RowElement row) {
        ArrayList<Renderer> cols = new ArrayList<Renderer>(row.getCols().size());
        for (Element col : row.getCols()) {
            cols.add(col.renderer());
        }
        this.cols = cols;
        this.style = row.getStyle();
        this.header = row.header;
    }

    public boolean isHeader() {
        return this.header;
    }

    int getSize() {
        return this.cols.size();
    }

    public List<Renderer> getCols() {
        return this.cols;
    }

    public LineReader renderer(final int width, Border border) {
        int[] widths = new int[this.cols.size()];
        int[] minWidths = new int[this.cols.size()];
        for (int i = 0; i < this.cols.size(); ++i) {
            Renderer renderable = this.cols.get(i);
            widths[i] = Math.max(widths[i], renderable.getActualWidth());
            minWidths[i] = Math.max(minWidths[i], renderable.getMinWidth());
        }
        widths = ColumnLayout.rightToLeft().compute(border, width, widths, minWidths);
        if (widths == null) {
            return new LineReader(){

                public int getWidth() {
                    return width;
                }

                public boolean hasLine() {
                    return false;
                }

                public void renderLine(RenderAppendable to) throws IllegalStateException {
                    throw new IllegalStateException();
                }
            };
        }
        return this.renderer(widths, width, border);
    }

    public LineReader renderer(final int[] widths, final int width, final Border border) {
        AtomicInteger totalWidth = new AtomicInteger();
        final LineReader[] renderers = new LineReader[this.cols.size()];
        for (int i = 0; i < this.cols.size(); ++i) {
            if (widths[i] <= 0) continue;
            renderers[i] = this.cols.get(i).renderer(widths[i]);
            totalWidth.addAndGet(widths[i]);
        }
        return new LineReader(){

            public boolean hasLine() {
                for (LineReader renderer : renderers) {
                    if (renderer == null || !renderer.hasLine()) continue;
                    return true;
                }
                return false;
            }

            public void renderLine(RenderAppendable to) {
                int total = 0;
                if (border != null) {
                    to.styleOff();
                    to.append(border.vertical);
                    to.styleOn();
                    ++total;
                }
                if (RowRenderer.this.style != null) {
                    to.enterStyle(RowRenderer.this.style);
                }
                for (int i = 0; i < renderers.length; ++i) {
                    LineReader renderer = renderers[i];
                    if (widths[i] <= 0) continue;
                    if (i > 0 && border != null) {
                        to.styleOff();
                        to.append(border.vertical);
                        to.styleOn();
                        ++total;
                    }
                    total += widths[i];
                    if (renderer != null && renderer.hasLine()) {
                        renderer.renderLine(to);
                        continue;
                    }
                    renderers[i] = null;
                    for (int j = widths[i]; j > 0; --j) {
                        to.append(' ');
                    }
                }
                if (RowRenderer.this.style != null) {
                    to.leaveStyle();
                }
                if (border != null) {
                    to.styleOff();
                    to.append(border.vertical);
                    to.styleOff();
                }
                while (true) {
                    int n = ++total;
                    ++total;
                    if (n >= width) break;
                    to.append(' ');
                }
            }
        };
    }

    @Override
    public LineReader renderer(int width) {
        return this.renderer(width, null);
    }

    @Override
    public int getActualWidth() {
        int width = 0;
        for (Renderer col : this.cols) {
            width += col.getActualWidth();
        }
        return width;
    }

    @Override
    public int getMinWidth() {
        int minWidth = 0;
        for (Renderer col : this.cols) {
            minWidth += col.getMinWidth();
        }
        return minWidth;
    }
}

