/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import groovy.lang.Closure;
import groovy.util.BuilderSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.crsh.text.Color;
import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.ui.Border;
import org.crsh.text.ui.ColumnLayout;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.EvalElement;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.RowElement;
import org.crsh.text.ui.TableElement;
import org.crsh.text.ui.TreeElement;
import org.crsh.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIBuilder
extends BuilderSupport
implements Iterable<Renderer> {
    private final List<Element> elements = new ArrayList<Element>();

    public List<Element> getElements() {
        return this.elements;
    }

    @Override
    protected Object doInvokeMethod(String methodName, Object name, Object args) {
        if ("eval".equals(name)) {
            List list = InvokerHelper.asList(args);
            if (list.size() == 1 && list.get(0) instanceof Closure) {
                EvalElement element = (EvalElement)super.doInvokeMethod(methodName, name, null);
                element.closure = (Closure)list.get(0);
                return element;
            }
            return super.doInvokeMethod(methodName, name, args);
        }
        return super.doInvokeMethod(methodName, name, args);
    }

    @Override
    protected Object createNode(Object name) {
        return this.createNode(name, (Object)null);
    }

    @Override
    protected Object createNode(Object name, Map attributes, Object value) {
        Element element;
        if ("node".equals(name)) {
            element = value == null ? new TreeElement() : new TreeElement(new LabelElement(value));
        } else if ("label".equals(name)) {
            element = new LabelElement(value);
        } else if ("table".equals(name)) {
            TableElement table = new TableElement();
            table.setHeight((Integer)attributes.get("height"));
            element = table;
        } else if ("row".equals(name)) {
            element = new RowElement();
        } else if ("header".equals(name)) {
            element = new RowElement(true);
        } else if ("eval".equals(name)) {
            element = new EvalElement();
        } else {
            throw new UnsupportedOperationException("Cannot build object with name " + name + " and value " + value);
        }
        Style.Composite style = element.getStyle();
        if (style == null) {
            style = Style.style();
        }
        style = style.foreground((Color)((Object)attributes.get("fg"))).foreground((Color)((Object)attributes.get("foreground"))).background((Color)((Object)attributes.get("bg"))).background((Color)((Object)attributes.get("background"))).bold((Boolean)attributes.get("bold")).underline((Boolean)attributes.get("underline")).blink((Boolean)attributes.get("blink"));
        element.setStyle(style);
        if (element instanceof TableElement) {
            Object border;
            TableElement table = (TableElement)element;
            Object weightsAttr = attributes.get("weights");
            if (weightsAttr instanceof Iterable) {
                List list = Utils.list((Iterable)weightsAttr);
                int[] weights = new int[list.size()];
                for (int i = 0; i < weights.length; ++i) {
                    weights[i] = (Integer)list.get(i);
                }
                table.layout(ColumnLayout.weighted(weights));
            }
            Border borderChar = (border = attributes.get("border")) instanceof Boolean && (Boolean)border != false ? Border.dashed : (border instanceof Border ? (Border)((Object)border) : null);
            table.border(borderChar);
        }
        return element;
    }

    @Override
    protected Object createNode(Object name, Object value) {
        return this.createNode(name, Collections.emptyMap(), value);
    }

    @Override
    protected Object createNode(Object name, Map attributes) {
        return this.createNode(name, attributes, null);
    }

    @Override
    protected void setParent(Object parent, Object child) {
        if (parent instanceof TreeElement) {
            TreeElement parentElement = (TreeElement)parent;
            Element childElement = (Element)child;
            parentElement.addChild(childElement);
        } else if (parent instanceof TableElement) {
            TableElement parentElement = (TableElement)parent;
            RowElement childElement = (RowElement)child;
            parentElement.add(childElement);
        } else if (parent instanceof RowElement) {
            RowElement parentElement = (RowElement)parent;
            Element childElement = (Element)child;
            if (child instanceof TreeElement) {
                throw new IllegalArgumentException("A table cannot contain a tree element");
            }
            parentElement.add(childElement);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    protected void nodeCompleted(Object parent, Object child) {
        if (parent == null) {
            this.elements.add((Element)child);
        }
        super.nodeCompleted(parent, child);
    }

    @Override
    public Iterator<Renderer> iterator() {
        return new Iterator<Renderer>(){
            Iterator<Element> i;
            {
                this.i = UIBuilder.this.elements.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public Renderer next() {
                return this.i.next().renderer();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

