/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.util.ArrayList;
import java.util.Arrays;
import org.crsh.command.ScriptException;
import org.crsh.shell.AbstractCommandTestCase;
import org.crsh.shell.ErrorType;
import org.crsh.text.ChunkBuffer;

public class PipeTestCase
extends AbstractCommandTestCase {
    private final String produce_command = "class produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<String> context) {\n['foo','bar'].each { context.provide(it) }}\n}";
    private final String consume_command = "class consume_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic org.crsh.command.PipeCommand<String> main() {\nreturn new org.crsh.command.PipeCommand<String>() {\npublic void provide(String element) {\norg.crsh.shell.PipeTestCase.list.add(element);\n}\n}\n}\n}";
    private final String consume_command_with_option = "class consume_command_with_option extends org.crsh.command.CRaSHCommand {\n@Command\npublic org.crsh.command.PipeCommand<String> main(\n@org.crsh.cmdline.annotations.Option(names=['opt']) String opt,\n@org.crsh.cmdline.annotations.Argument List<String> args) {\nargs.each { org.crsh.shell.PipeTestCase.list.add((opt?:'') + it) }\nreturn new org.crsh.command.PipeCommand<String>() {\npublic void provide(String element) {\norg.crsh.shell.PipeTestCase.list.add((opt?:'') + element);\n}\n}\n}\n}";
    public static final ArrayList<?> list = new ArrayList();

    public void testProduceToClosure() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nproduce_command { out << it }\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("produce_command", "class produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<String> context) {\n['foo','bar'].each { context.provide(it) }}\n}");
        PipeTestCase.assertEquals((String)"foobar", (String)this.assertOk("foo"));
    }

    public void testIsPiped() {
        String piped = "class piped extends org.crsh.command.CRaSHCommand {\n@Command\npublic org.crsh.command.PipeCommand<Object> main() {\nreturn new org.crsh.command.PipeCommand<Object>() {\npublic void open() {\norg.crsh.shell.PipeTestCase.list.add(isPiped());\n}\n}\n}\n}";
        this.lifeCycle.setCommand("piped", piped);
        this.lifeCycle.setCommand("produce_command", "class produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<String> context) {\n['foo','bar'].each { context.provide(it) }}\n}");
        list.clear();
        PipeTestCase.assertEquals((String)"", (String)this.assertOk("piped"));
        PipeTestCase.assertEquals(Arrays.asList(Boolean.FALSE), list);
        list.clear();
        PipeTestCase.assertEquals((String)"", (String)this.assertOk("produce_command | piped"));
        PipeTestCase.assertEquals(Arrays.asList(Boolean.TRUE), list);
        this.lifeCycle.setCommand("inscript", "produce_command piped");
        list.clear();
        PipeTestCase.assertEquals((String)"", (String)this.assertOk("inscript"));
        PipeTestCase.assertEquals(Arrays.asList(Boolean.TRUE), list);
    }

    public void testProduceToCommandAsClosure() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ndef closure = consume_command\nproduce_command closure\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("produce_command", "class produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<String> context) {\n['foo','bar'].each { context.provide(it) }}\n}");
        this.lifeCycle.setCommand("consume_command", "class consume_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic org.crsh.command.PipeCommand<String> main() {\nreturn new org.crsh.command.PipeCommand<String>() {\npublic void provide(String element) {\norg.crsh.shell.PipeTestCase.list.add(element);\n}\n}\n}\n}");
        list.clear();
        PipeTestCase.assertEquals((String)"", (String)this.assertOk("foo"));
        PipeTestCase.assertEquals(Arrays.asList("foo", "bar"), list);
    }

    public void testProduceToCommandWithOptionAsClosure() {
        String noOpt = "class noOpt extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ndef closure = consume_command_with_option\nproduce_command closure\n}\n}";
        String opt = "class opt extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ndef closure = consume_command_with_option.with(opt:'prefix')\nproduce_command closure\n}\n}";
        String args = "class args extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ndef closure = consume_command_with_option.with('juu')\nproduce_command closure\n}\n}";
        String optArgs = "class args extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ndef closure = consume_command_with_option.with(opt:'prefix','juu')\nproduce_command closure\n}\n}";
        this.lifeCycle.setCommand("noOpt", noOpt);
        this.lifeCycle.setCommand("opt", opt);
        this.lifeCycle.setCommand("args", args);
        this.lifeCycle.setCommand("optArgs", optArgs);
        this.lifeCycle.setCommand("produce_command", "class produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<String> context) {\n['foo','bar'].each { context.provide(it) }}\n}");
        this.lifeCycle.setCommand("consume_command_with_option", "class consume_command_with_option extends org.crsh.command.CRaSHCommand {\n@Command\npublic org.crsh.command.PipeCommand<String> main(\n@org.crsh.cmdline.annotations.Option(names=['opt']) String opt,\n@org.crsh.cmdline.annotations.Argument List<String> args) {\nargs.each { org.crsh.shell.PipeTestCase.list.add((opt?:'') + it) }\nreturn new org.crsh.command.PipeCommand<String>() {\npublic void provide(String element) {\norg.crsh.shell.PipeTestCase.list.add((opt?:'') + element);\n}\n}\n}\n}");
        list.clear();
        PipeTestCase.assertEquals((String)"", (String)this.assertOk("noOpt"));
        PipeTestCase.assertEquals(Arrays.asList("foo", "bar"), list);
        list.clear();
        PipeTestCase.assertEquals((String)"", (String)this.assertOk("opt"));
        PipeTestCase.assertEquals(Arrays.asList("prefixfoo", "prefixbar"), list);
        list.clear();
        PipeTestCase.assertEquals((String)"", (String)this.assertOk("args"));
        PipeTestCase.assertEquals(Arrays.asList("juu", "foo", "bar"), list);
        list.clear();
        PipeTestCase.assertEquals((String)"", (String)this.assertOk("optArgs"));
        PipeTestCase.assertEquals(Arrays.asList("prefixjuu", "prefixfoo", "prefixbar"), list);
    }

    public void testProduceToClosureInScript() {
        this.lifeCycle.setCommand("foo", "produce_command { out << it }\n");
        this.lifeCycle.setCommand("produce_command", "class produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<String> context) {\n['foo','bar'].each { context.provide(it) }}\n}");
        PipeTestCase.assertEquals((String)"foobar", (String)this.assertOk("foo"));
    }

    public void testKeepLastPipeContent() throws Exception {
        PipeTestCase.assertEquals((String)"bar", (String)this.assertOk("echo foo | echo bar"));
    }

    public void testFlushInPipe() throws Exception {
        PipeTestCase.assertEquals((String)"juu", (String)this.assertOk("echo -f 1 foo bar | echo juu"));
    }

    public void testProducerCannotUseWriter() throws Exception {
        String cmd = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<Integer> context) {\ncontext.getWriter().print('foo');\n}\n}";
        this.lifeCycle.setCommand("cmd", cmd);
        PipeTestCase.assertEquals((String)"foo", (String)this.assertOk("cmd"));
    }

    public void testProducerWithFormatter() throws Exception {
        String cmd = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<org.crsh.shell.Foo> context) {\ncontext.provide(new org.crsh.shell.Foo('abc'));\n}\n}";
        this.lifeCycle.setCommand("cmd", cmd);
        PipeTestCase.assertEquals((String)"<foo>abc</foo>                  \n", (String)this.assertOk("cmd"));
    }

    public void testAdaptToChunk() {
        String producer = "class producer extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<org.crsh.shell.Foo> context) {\ncontext.provide(new org.crsh.shell.Foo('abc'));\n}\n}";
        String consumer = "class consumer extends org.crsh.command.CRaSHCommand {\n  @Command\n  public org.crsh.command.PipeCommand<org.crsh.text.Chunk> main() {\n    return new org.crsh.command.PipeCommand<org.crsh.text.Chunk>() {\n      public void provide(org.crsh.text.Chunk element) {\n        org.crsh.shell.PipeTestCase.list.add(element);\n      }\n    };\n  }\n}";
        this.lifeCycle.setCommand("producer", producer);
        this.lifeCycle.setCommand("consumer", consumer);
        list.clear();
        this.assertOk("producer | consumer");
        ChunkBuffer buffer = new ChunkBuffer().append(list);
        PipeTestCase.assertEquals((String)"<foo>abc</foo>                  \n", (String)buffer.toString());
    }

    public void testIncompatibleType() throws Exception {
        String producer = "class producer extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<Integer> context) {\ncontext.provide(3);\n}\n}";
        String consumer = "class producer extends org.crsh.command.CRaSHCommand {\n  @Command\n  public org.crsh.command.PipeCommand<Boolean> main() {\n    return new org.crsh.command.PipeCommand<Boolean>() {\n      public void provide(Boolean element) {\n        throw new RuntimeException('Was not expecting invocation to work');\n      }\n    }\n  }\n}";
        this.lifeCycle.setCommand("producer", producer);
        this.lifeCycle.setCommand("consumer", consumer);
        this.assertOk("producer | consumer");
    }

    public void testProducerConsumer() throws Exception {
        String producer = "class producer extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<Integer> context) {\ncontext.provide(3);\n}\n}";
        String consumer = "class producer extends org.crsh.command.CRaSHCommand {\n  @Command\n  public org.crsh.command.PipeCommand<Integer> main() {\n    return new org.crsh.command.PipeCommand<Integer>() {\n      int count = 0;\n      public void provide(Integer element) {\n        org.crsh.shell.PipeTestCase.list.add(element);\n      }\n    };\n  }\n}\n";
        this.lifeCycle.setCommand("producer", producer);
        this.lifeCycle.setCommand("consumer", consumer);
        list.clear();
        this.assertOk("producer | consumer");
        PipeTestCase.assertEquals(Arrays.asList(3), list);
    }

    public void testProducerThrowsScriptExceptionInProvide() throws Exception {
        String producer = "class producer extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main(org.crsh.command.InvocationContext<Integer> context) {\ncontext.provide(3);\n}\n}";
        String consumer = "class producer extends org.crsh.command.CRaSHCommand {\n  @Command\n  public org.crsh.command.PipeCommand<Integer> main() {\n    return new org.crsh.command.PipeCommand<Integer>() {\n      public void provide(Integer element) {\n        throw new org.crsh.command.ScriptException('foo')\n      }\n    };\n  }\n}\n";
        this.lifeCycle.setCommand("producer", producer);
        this.lifeCycle.setCommand("consumer", consumer);
        list.clear();
        Throwable t = this.assertError("producer | consumer", ErrorType.EVALUATION);
        ScriptException ex = PipeTestCase.assertInstance(ScriptException.class, t);
        PipeTestCase.assertEquals((String)"foo", (String)ex.getMessage());
    }
}

