/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.awt.AWTError;
import java.util.EmptyStackException;
import javax.management.JMException;
import org.crsh.command.ScriptException;
import org.crsh.shell.AbstractCommandTestCase;

public class ThrowableTestCase
extends AbstractCommandTestCase {
    public void testThrowScript() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws org.crsh.command.ScriptException {\nthrow new org.crsh.command.ScriptException()}\n}\n");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testThrowGroovyScript() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws groovy.util.ScriptException {\nthrow new groovy.util.ScriptException()}\n}\n");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testThrowCheckedException() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws javax.management.JMException {\nthrow new javax.management.JMException()}\n}\n");
        this.assertEvalError("a", JMException.class);
    }

    public void testThrowRuntimeException() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws java.util.EmptyStackException {\nthrow new java.util.EmptyStackException()}\n}\n");
        this.assertEvalError("a", EmptyStackException.class);
    }

    public void testThrowError() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws java.awt.AWTError {\nthrow new java.awt.AWTError()}\n}\n");
        this.assertInternalError("a", AWTError.class);
    }

    public void testUndeclaredThrowScript() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new org.crsh.command.ScriptException()}\n}\n");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testUndeclaredThrowGroovyScript() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new groovy.util.ScriptException()}\n}\n");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testUndeclaredThrowCheckedException() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new javax.management.JMException()}\n}\n");
        this.assertEvalError("a", JMException.class);
    }

    public void testUndeclaredThrowRuntimeException() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new java.util.EmptyStackException()}\n}\n");
        this.assertEvalError("a", EmptyStackException.class);
    }

    public void testUndeclaredThrowError() throws Exception {
        this.lifeCycle.setCommand("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new java.awt.AWTError()}\n}\n");
        this.assertInternalError("a", AWTError.class);
    }

    public void testScriptThrowScript() throws Exception {
        this.lifeCycle.setCommand("a", "throw new org.crsh.command.ScriptException()");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testScriptThrowGroovyScript() throws Exception {
        this.lifeCycle.setCommand("a", "throw new groovy.util.ScriptException()");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testScriptThrowCheckedException() throws Exception {
        this.lifeCycle.setCommand("a", "throw new javax.management.JMException()");
        this.assertEvalError("a", JMException.class);
    }

    public void testScriptThrowRuntimeException() throws Exception {
        this.lifeCycle.setCommand("a", "throw new java.util.EmptyStackException()");
        this.assertEvalError("a", EmptyStackException.class);
    }

    public void testScriptThrowError() throws Exception {
        this.lifeCycle.setCommand("a", "throw new java.awt.AWTError()");
        this.assertInternalError("a", AWTError.class);
    }
}

