/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import org.crsh.text.Color;
import org.crsh.text.ui.AbstractRendererTestCase;
import org.crsh.text.ui.Border;
import org.crsh.text.ui.ColumnLayout;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.RowElement;
import org.crsh.text.ui.TableElement;

public class TableRendererTestCase
extends AbstractRendererTestCase {
    public void testSimple() throws Exception {
        TableElement table = new TableElement();
        table.layout(ColumnLayout.rightToLeft());
        table.add(Element.row().add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c")}).add(new Element[]{Element.label((String)"d")}));
        this.assertRender((Element)table, 2, "ab", "cd");
    }

    public void testHeterogeneous() throws Exception {
        TableElement table = new TableElement(new int[]{1, 2});
        table.add(Element.row().add(new Element[]{Element.label((String)"foo")})).add(Element.row().add(new Element[]{Element.label((String)"aa")}).add(new Element[]{Element.label((String)"bb")})).add(Element.row().add(new Element[]{Element.label((String)"cc")}).add(new Element[]{Element.label((String)"dd")}).add(new Element[]{Element.label((String)"ee")}));
        this.assertRender((Element)table, 3, "foo", "abb", "a  ", "cdd", "c  ");
    }

    public void testRenderWithoutBorder() throws Exception {
        TableElement table = new TableElement();
        RowElement row = new RowElement().add(new Element[]{new LabelElement("foo"), new LabelElement("bar")});
        table.add(row);
        table.layout(ColumnLayout.rightToLeft());
        this.assertRender((Element)table, 11, "foobar     ");
        this.assertRender((Element)table, 10, "foobar    ");
        this.assertRender((Element)table, 9, "foobar   ");
        this.assertRender((Element)table, 8, "foobar  ");
        this.assertRender((Element)table, 7, "foobar ");
        this.assertRender((Element)table, 6, "foobar");
        this.assertRender((Element)table, 5, "fooba", "   r ");
        this.assertRender((Element)table, 4, "foob", "   a", "   r");
        this.assertRender((Element)table, 3, "foo");
        this.assertRender((Element)table, 2, "fo", "o ");
        this.assertRender((Element)table, 1, "f", "o", "o");
        this.assertRender((Element)table, 0, new String[0]);
        table.layout(ColumnLayout.weighted((int[])new int[]{1, 1}));
        this.assertRender((Element)table, 11, "foo   bar  ");
        this.assertRender((Element)table, 10, "foo  bar  ");
        this.assertRender((Element)table, 9, "foo  bar ");
        this.assertRender((Element)table, 8, "foo bar ");
        this.assertRender((Element)table, 7, "foo bar");
        this.assertRender((Element)table, 6, "foobar");
        this.assertRender((Element)table, 5, "fooba", "   r ");
        this.assertRender((Element)table, 4, "foba", "o r ");
        this.assertRender((Element)table, 3, "fob", "o a", "  r");
        this.assertRender((Element)table, 2, "fb", "oa", "or");
        this.assertRender((Element)table, 0, new String[0]);
        table.layout(ColumnLayout.weighted((int[])new int[]{1, 2}));
        this.assertRender((Element)table, 11, "foo bar    ");
        this.assertRender((Element)table, 10, "foobar    ");
        this.assertRender((Element)table, 9, "foobar   ");
        this.assertRender((Element)table, 8, "foobar  ");
        this.assertRender((Element)table, 7, "fobar  ", "o      ");
        this.assertRender((Element)table, 6, "fobar ", "o     ");
        this.assertRender((Element)table, 5, "fobar", "o    ");
        this.assertRender((Element)table, 4, "fbar", "o   ", "o   ");
        this.assertRender((Element)table, 3, "fba", "or ", "o  ");
        this.assertRender((Element)table, 2, "fo", "o ");
        this.assertRender((Element)table, 1, "f", "o", "o");
        this.assertRender((Element)table, 0, new String[0]);
    }

    public void testRenderWithBorder() throws Exception {
        TableElement table = new TableElement().border(Border.dashed);
        RowElement row = new RowElement().add(new Element[]{new LabelElement("foo"), new LabelElement("bar")});
        table.add(row);
        table.layout(ColumnLayout.rightToLeft());
        this.assertRender((Element)table, 11, " -------   ", "|foo|bar|  ", " -------   ");
        this.assertRender((Element)table, 10, " -------  ", "|foo|bar| ", " -------  ");
        this.assertRender((Element)table, 9, " ------- ", "|foo|bar|", " ------- ");
        this.assertRender((Element)table, 8, " ------ ", "|foo|ba|", "|   |r |", " ------ ");
        this.assertRender((Element)table, 7, " ----- ", "|foo|b|", "|   |a|", "|   |r|", " ----- ");
        this.assertRender((Element)table, 6, " ---  ", "|foo| ", " ---  ");
        this.assertRender((Element)table, 5, " --- ", "|foo|", " --- ");
        this.assertRender((Element)table, 4, " -- ", "|fo|", "|o |", " -- ");
        this.assertRender((Element)table, 3, " - ", "|f|", "|o|", "|o|", " - ");
        this.assertRender((Element)table, 2, new String[0]);
        this.assertRender((Element)table, 1, new String[0]);
        this.assertRender((Element)table, 0, new String[0]);
        table.layout(ColumnLayout.weighted((int[])new int[]{1, 1}));
        this.assertRender((Element)table, 11, " --------- ", "|foo |bar |", " --------- ");
        this.assertRender((Element)table, 10, " -------- ", "|foo |bar|", " -------- ");
        this.assertRender((Element)table, 9, " ------- ", "|foo|bar|", " ------- ");
        this.assertRender((Element)table, 8, " ------ ", "|foo|ba|", "|   |r |", " ------ ");
        this.assertRender((Element)table, 7, " ----- ", "|fo|ba|", "|o |r |", " ----- ");
        this.assertRender((Element)table, 6, " ---- ", "|fo|b|", "|o |a|", "|  |r|", " ---- ");
        this.assertRender((Element)table, 5, " --- ", "|f|b|", "|o|a|", "|o|r|", " --- ");
        this.assertRender((Element)table, 4, " -- ", "|fo|", "|o |", " -- ");
        this.assertRender((Element)table, 3, " - ", "|f|", "|o|", "|o|", " - ");
        this.assertRender((Element)table, 2, new String[0]);
        this.assertRender((Element)table, 1, new String[0]);
        this.assertRender((Element)table, 0, new String[0]);
        table.layout(ColumnLayout.weighted((int[])new int[]{1, 2}));
        this.assertRender((Element)table, 11, " --------- ", "|foo|bar  |", " --------- ");
        this.assertRender((Element)table, 10, " -------- ", "|fo|bar  |", "|o |     |", " -------- ");
        this.assertRender((Element)table, 9, " ------- ", "|fo|bar |", "|o |    |", " ------- ");
        this.assertRender((Element)table, 8, " ------ ", "|fo|bar|", "|o |   |", " ------ ");
        this.assertRender((Element)table, 7, " ----- ", "|f|bar|", "|o|   |", "|o|   |", " ----- ");
        this.assertRender((Element)table, 6, " ---- ", "|f|ba|", "|o|r |", "|o|  |", " ---- ");
        this.assertRender((Element)table, 5, " --- ", "|foo|", " --- ");
        this.assertRender((Element)table, 4, " -- ", "|fo|", "|o |", " -- ");
        this.assertRender((Element)table, 3, " - ", "|f|", "|o|", "|o|", " - ");
        this.assertRender((Element)table, 2, new String[0]);
        this.assertRender((Element)table, 1, new String[0]);
        this.assertRender((Element)table, 0, new String[0]);
    }

    public void testCosmetic() throws Exception {
        TableElement table = new TableElement();
        table.layout(ColumnLayout.rightToLeft());
        RowElement row = new RowElement().add(new Element[]{new LabelElement("foo", 5), new LabelElement("This text is larger to be displayed in a cell of 32", 5)});
        table.add(row);
        this.assertRender((Element)table, 32, "fooThis text is larger to be dis", "   played in a cell of 32       ");
    }

    public void testCosmeticWithBorder() throws Exception {
        TableElement table = new TableElement();
        table.layout(ColumnLayout.rightToLeft());
        RowElement row = new RowElement().add(new Element[]{new LabelElement("foo", 5), new LabelElement("This text is larger to be displayed in a cell of 32", 5)});
        table.border(Border.dashed);
        table.add(row);
        this.assertRender((Element)table, 32, " ------------------------------ ", "|foo|This text is larger to be |", "|   |displayed in a cell of 32 |", " ------------------------------ ");
    }

    public void testBorderStyle() throws Exception {
        TableElement table = new TableElement();
        table.layout(ColumnLayout.rightToLeft());
        table.border(Border.dashed);
        table.add(Element.row().style(Color.blue.fg().bg(Color.green).bold()).add(new Element[]{Element.label((String)"a")}).add(new Element[]{Element.label((String)"b")})).add(Element.row().add(new Element[]{Element.label((String)"c").style(Color.blue.fg().bg(Color.green).bold())}).add(new Element[]{Element.label((String)"d")}));
    }
}

