/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.tokenizer;

import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.matcher.tokenizer.Escape;
import org.crsh.cmdline.matcher.tokenizer.State;
import org.crsh.cmdline.matcher.tokenizer.Token;
import org.crsh.cmdline.matcher.tokenizer.Tokenizer;

public class TokenizerImpl
extends Tokenizer {
    private final CharSequence s;
    private int index;
    private Delimiter delimiter;

    public TokenizerImpl(CharSequence s) {
        this.s = s;
        this.index = 0;
        this.delimiter = null;
    }

    protected Token parse() {
        Token token = null;
        if (this.index < this.s.length()) {
            char c = this.s.charAt(this.index);
            int from = this.index;
            while (Character.isWhitespace(c)) {
                ++this.index;
                if (this.index >= this.s.length()) break;
                c = this.s.charAt(this.index);
            }
            if (this.index > from) {
                token = new Token.Whitespace(from, ((Object)this.s.subSequence(from, this.index)).toString());
            } else {
                State state = new State();
                while (!Character.isWhitespace(c) || state.escape != Escape.NONE) {
                    ++this.index;
                    state.push(c);
                    if (this.index >= this.s.length()) break;
                    c = this.s.charAt(this.index);
                }
                if (this.index > from) {
                    switch (state.status) {
                        case INIT: {
                            token = new Token.Literal.Word(from, ((Object)this.s.subSequence(from, this.index)).toString(), state.buffer.toString());
                            break;
                        }
                        case WORD: {
                            token = new Token.Literal.Word(from, ((Object)this.s.subSequence(from, this.index)).toString(), state.buffer.toString());
                            break;
                        }
                        case SHORT_OPTION: {
                            token = new Token.Literal.Option.Short(from, ((Object)this.s.subSequence(from, this.index)).toString(), state.buffer.toString());
                            break;
                        }
                        case LONG_OPTION: {
                            token = new Token.Literal.Option.Long(from, ((Object)this.s.subSequence(from, this.index)).toString(), state.buffer.toString());
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)state.status);
                        }
                    }
                    this.delimiter = state.escape.delimiter;
                    return token;
                }
            }
        }
        return token;
    }

    public Delimiter getDelimiter() {
        return this.delimiter;
    }
}

