/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.util.ArrayList;
import java.util.Arrays;
import org.crsh.shell.AbstractCommandTestCase;

public class CompositionTestCase
extends AbstractCommandTestCase {
    public static final ArrayList<?> list = new ArrayList();
    private final String compound_command = "class compound_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String compound() {\nreturn 'bar';}\n}";
    private final String compound_produce_command = "class compound_produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void compound(org.crsh.command.InvocationContext<String> context) {\n['foo','bar'].each { context.provide(it) }}\n}";
    private final String compound_consume_command = "class compound_consume_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic org.crsh.command.PipeCommand<String, Object> compound() {\nreturn new org.crsh.command.PipeCommand<String, Object>() {\npublic void provide(String element) {\norg.crsh.shell.CompositionTestCase.list.add(element);\n}\n}\n}\n}";
    private final String checked_exception_command = "class checked_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new javax.naming.NamingException();}\n}";
    private final String script_exception_command = "class script_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new org.crsh.command.ScriptException();}\n}";
    private final String groovy_script_exception_command = "class groovy_script_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new groovy.util.ScriptException();}\n}";
    private final String runtime_exception_command = "class runtime_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new java.lang.SecurityException();}\n}";
    private final String error_command = "class error_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new java.awt.AWTError();}\n}";
    private final String cannot_create_command = "class cannot_create_command extends org.crsh.command.CRaSHCommand {\n{ throw new RuntimeException(); } \n@Command\npublic String main() {\nthrow new java.awt.AWTError();}\n}";

    public void testInvokeCompound() throws Exception {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ncompound_command.compound 'bar'\n}\n}";
        this.lifeCycle.setCommand("compound_command", "class compound_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String compound() {\nreturn 'bar';}\n}");
        this.lifeCycle.setCommand("foo", foo);
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testInvokeCompoundInScript() throws Exception {
        String foo = "compound_command.compound 'bar'\n";
        this.lifeCycle.setCommand("compound_command", "class compound_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String compound() {\nreturn 'bar';}\n}");
        this.lifeCycle.setCommand("foo", foo);
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testClosureInScript() {
        String foo = "def closure = echo\nclosure 'bar'\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("compound_command", "class compound_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String compound() {\nreturn 'bar';}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCompoundClosure() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ndef closure = compound_command.compound\nclosure()\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("compound_command", "class compound_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String compound() {\nreturn 'bar';}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCompoundClosureInScript() {
        String foo = "def closure = compound_command.compound\nclosure()\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("compound_command", "class compound_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String compound() {\nreturn 'bar';}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCompoundProduceToClosure() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ncompound_produce_command.compound { out << it }\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("compound_produce_command", "class compound_produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void compound(org.crsh.command.InvocationContext<String> context) {\n['foo','bar'].each { context.provide(it) }}\n}");
        CompositionTestCase.assertEquals((String)"foobar", (String)this.assertOk("foo"));
        String bar = "class bar extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ncompound_produce_command.compound { boolean it -> out << it }\n}\n}";
        this.lifeCycle.setCommand("bar", bar);
        this.lifeCycle.setCommand("compound_produce_command", "class compound_produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void compound(org.crsh.command.InvocationContext<String> context) {\n['foo','bar'].each { context.provide(it) }}\n}");
        CompositionTestCase.assertEquals((String)"", (String)this.assertOk("bar"));
    }

    public void testCompoundProduceToClosureInScript() {
        String foo = "compound_produce_command.compound { out << it }\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("compound_produce_command", "class compound_produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void compound(org.crsh.command.InvocationContext<String> context) {\n['foo','bar'].each { context.provide(it) }}\n}");
        CompositionTestCase.assertEquals((String)"foobar", (String)this.assertOk("foo"));
        String bar = "compound_produce_command.compound { boolean it -> out << it }\n";
        this.lifeCycle.setCommand("bar", bar);
        this.lifeCycle.setCommand("compound_produce_command", "class compound_produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void compound(org.crsh.command.InvocationContext<String> context) {\n['foo','bar'].each { context.provide(it) }}\n}");
        CompositionTestCase.assertEquals((String)"", (String)this.assertOk("bar"));
    }

    public void testCompoundCommandAsClosure() {
        String foo = "def closure = compound_consume_command.compound\ncompound_produce_command.compound closure\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("compound_produce_command", "class compound_produce_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic void compound(org.crsh.command.InvocationContext<String> context) {\n['foo','bar'].each { context.provide(it) }}\n}");
        this.lifeCycle.setCommand("compound_consume_command", "class compound_consume_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic org.crsh.command.PipeCommand<String, Object> compound() {\nreturn new org.crsh.command.PipeCommand<String, Object>() {\npublic void provide(String element) {\norg.crsh.shell.CompositionTestCase.list.add(element);\n}\n}\n}\n}");
        list.clear();
        CompositionTestCase.assertEquals((String)"", (String)this.assertOk("foo"));
        CompositionTestCase.assertEquals(Arrays.asList("foo", "bar"), list);
    }

    public void testCheckedException() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ntry {checked_exception_command()} catch(javax.naming.NamingException e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("checked_exception_command", "class checked_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new javax.naming.NamingException();}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCheckedExceptionInScript() {
        String foo = "try {checked_exception_command()} catch(javax.naming.NamingException e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("checked_exception_command", "class checked_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new javax.naming.NamingException();}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testScriptException() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ntry {script_exception_command()} catch(org.crsh.command.ScriptException e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("script_exception_command", "class script_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new org.crsh.command.ScriptException();}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testScriptExceptionInScript() {
        String foo = "try {script_exception_command()} catch(org.crsh.command.ScriptException e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("script_exception_command", "class script_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new org.crsh.command.ScriptException();}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testGroovyScriptException() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ntry {groovy_script_exception_command()} catch(org.crsh.command.ScriptException e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("groovy_script_exception_command", "class groovy_script_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new groovy.util.ScriptException();}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testGroovyScriptExceptionInScript() {
        String foo = "try {groovy_script_exception_command()} catch(org.crsh.command.ScriptException e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("groovy_script_exception_command", "class groovy_script_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new groovy.util.ScriptException();}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testRuntimeException() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ntry {runtime_exception_command()} catch(java.lang.SecurityException e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("runtime_exception_command", "class runtime_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new java.lang.SecurityException();}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testRuntimeExceptionInScript() {
        String foo = "try {runtime_exception_command()} catch(java.lang.SecurityException e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("runtime_exception_command", "class runtime_exception_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new java.lang.SecurityException();}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testError() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ntry {error_command()} catch(java.awt.AWTError e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("error_command", "class error_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new java.awt.AWTError();}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testErrorInScript() {
        String foo = "try {error_command()} catch(java.awt.AWTError e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("error_command", "class error_command extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nthrow new java.awt.AWTError();}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCannotCreateCommand() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\ntry {\ncannot_create_command()} catch (org.crsh.command.NoSuchCommandException e) {\nreturn 'bar';\n}\n}\n}";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("cannot_create_command", "class cannot_create_command extends org.crsh.command.CRaSHCommand {\n{ throw new RuntimeException(); } \n@Command\npublic String main() {\nthrow new java.awt.AWTError();}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCannotCreateCommandInScript() {
        String foo = "try {\ncannot_create_command()} catch (org.crsh.command.NoSuchCommandException e) {\nreturn 'bar';\n}\n";
        this.lifeCycle.setCommand("foo", foo);
        this.lifeCycle.setCommand("cannot_create_command", "class cannot_create_command extends org.crsh.command.CRaSHCommand {\n{ throw new RuntimeException(); } \n@Command\npublic String main() {\nthrow new java.awt.AWTError();}\n}");
        CompositionTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }
}

