/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import java.io.IOException;
import org.crsh.text.ui.AbstractRendererTestCase;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.TreeElement;

public class TreeRendererTestCase
extends AbstractRendererTestCase {
    public void testSimple() throws IOException {
        TreeElement elt = new TreeElement();
        elt.addChild((Element)new LabelElement("1\n1"));
        elt.addChild((Element)new LabelElement("2"));
        this.assertRender((Element)elt, 4, "+-1 ", "| 1 ", "+-2 ");
    }

    public void testNested() throws Exception {
        TreeElement elt = new TreeElement((Element)new LabelElement("foo"));
        elt.addChild((Element)new TreeElement((Element)new LabelElement("bar")).addChild((Element)new LabelElement("1\n1")).addChild((Element)new LabelElement("2\n2")));
        elt.addChild((Element)new TreeElement().addChild((Element)new LabelElement("3")).addChild((Element)new LabelElement("4")));
        this.assertRender((Element)elt, 6, "foo   ", "+-bar ", "| +-1 ", "| | 1 ", "| +-2 ", "|   2 ", "+-+-3 ", "  +-4 ");
    }

    public void testTooLarge() throws IOException {
        TreeElement elt = new TreeElement();
        elt.addChild((Element)new LabelElement("foo value is very very very too large for the console"));
        elt.addChild((Element)new LabelElement("bar\n"));
        this.assertRender((Element)elt, 32, "+-foo value is very very very to", "| o large for the console       ", "+-bar                           ", "                                ");
    }
}

