/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.standalone;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.cli.Argument;
import org.crsh.cli.Command;
import org.crsh.cli.Option;
import org.crsh.cli.Usage;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.InvocationMatcher;
import org.crsh.cli.impl.lang.CommandFactory;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellFactory;
import org.crsh.shell.impl.remoting.RemoteClient;
import org.crsh.standalone.Bootstrap;
import org.crsh.standalone.ResourceMode;
import org.crsh.vfs.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agent {
    private static Logger log = Logger.getLogger(Agent.class.getName());
    private final Instrumentation instrumentation;

    public static void agentmain(final String agentArgs, final Instrumentation inst) throws Exception {
        log.log(Level.INFO, "CRaSH agent loaded");
        Thread t = new Thread(){

            public void run() {
                try {
                    CommandDescriptorImpl<Agent> c = CommandFactory.DEFAULT.create(Agent.class);
                    InvocationMatcher<Agent> matcher = c.invoker("main");
                    InvocationMatch<Agent> match = matcher.match(agentArgs);
                    match.invoke(new Agent(inst));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
        log.log(Level.INFO, "Spawned CRaSH thread " + t.getId() + " for further processing");
    }

    public Agent(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command
    public void main(@Option(names={"c", "cmd"}) @Usage(value="adds a dir to the command path") List<String> cmds, @Option(names={"conf"}) @Usage(value="adds a dir to the conf path") List<String> confs, @Option(names={"p", "property"}) @Usage(value="set a property of the form a=b") List<String> properties, @Option(names={"cmd-mode"}) @Usage(value="the cmd mode (read or copy), copy mode requires at least one cmd path to be specified") ResourceMode cmdMode, @Option(names={"conf-mode"}) @Usage(value="the conf mode (read of copy), copy mode requires at least one conf path to be specified") ResourceMode confMode, @Argument(name="port") Integer port) throws Exception {
        boolean copyCmd = cmdMode != ResourceMode.read && cmds != null && cmds.size() > 0;
        boolean copyConf = confMode != ResourceMode.read && confs != null && confs.size() > 0;
        Bootstrap bootstrap = new Bootstrap(Thread.currentThread().getContextClassLoader());
        if (!copyCmd) {
            bootstrap.addToCmdPath(Path.get("/crash/commands/"));
        }
        if (cmds != null) {
            for (String cmd : cmds) {
                File cmdPath = new File(cmd);
                bootstrap.addToCmdPath(cmdPath);
            }
        }
        if (!copyConf) {
            bootstrap.addToConfPath(Path.get("/crash/"));
        }
        if (confs != null) {
            for (String conf : confs) {
                File confPath = new File(conf);
                bootstrap.addToConfPath(confPath);
            }
        }
        if (properties != null) {
            Properties config = new Properties();
            for (String property : properties) {
                int index = property.indexOf(61);
                if (index == -1) {
                    config.setProperty(property, "");
                    continue;
                }
                config.setProperty(property.substring(0, index), property.substring(index + 1));
            }
            bootstrap.setConfig(config);
        }
        Map<String, Object> attributes = Collections.singletonMap("instrumentation", this.instrumentation);
        bootstrap.setAttributes(attributes);
        bootstrap.bootstrap();
        try {
            ShellFactory factory = bootstrap.getContext().getPlugin(ShellFactory.class);
            Shell shell = factory.create(null);
            RemoteClient client = new RemoteClient(port, shell);
            log.log(Level.INFO, "Callback back remote on port " + port);
            client.connect();
            client.getRunnable().run();
        }
        finally {
            bootstrap.shutdown();
        }
    }
}

