/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.processor.jline;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import jline.console.ConsoleReader;
import jline.console.completer.Completer;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.spi.Completion;
import org.crsh.processor.jline.JLineProcessContext;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JLineProcessor
implements Runnable,
Completer {
    private final Shell shell;
    final ConsoleReader reader;
    final PrintWriter writer;
    final AtomicReference<ShellProcess> current;
    boolean useAlternate;

    public JLineProcessor(Shell shell, ConsoleReader reader, PrintWriter writer) {
        this.shell = shell;
        this.reader = reader;
        this.writer = writer;
        this.current = new AtomicReference();
        this.useAlternate = false;
    }

    @Override
    public void run() {
        String welcome = this.shell.getWelcome();
        this.writer.println(welcome);
        this.writer.flush();
        this.loop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loop() {
        while (true) {
            String line;
            String prompt = this.getPrompt();
            try {
                this.writer.println();
                this.writer.flush();
                line = this.reader.readLine(prompt);
                if (line == null) {
                }
            }
            catch (IOException e) {}
            break;
            ShellProcess process = this.shell.createProcess(line);
            JLineProcessContext context = new JLineProcessContext(this);
            this.current.set(process);
            try {
                process.execute(context);
                try {
                    context.latch.await();
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            finally {
                this.current.set(null);
            }
            ShellResponse response = context.resp.get();
            boolean flushed = false;
            String msg = response.getMessage();
            if (msg.length() > 0) {
                this.writer.write(msg);
                this.writer.flush();
                flushed = true;
            }
            if (response instanceof ShellResponse.Cancelled) continue;
            if (response instanceof ShellResponse.Close) break;
            if (flushed) continue;
            this.writer.flush();
        }
    }

    @Override
    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        String prefix = buffer.substring(0, cursor);
        CompletionMatch completion = this.shell.complete(prefix);
        Completion vc = completion.getValue();
        if (vc.isEmpty()) {
            return -1;
        }
        Delimiter delimiter = completion.getDelimiter();
        for (Map.Entry<String, Boolean> entry : vc) {
            StringBuilder sb = new StringBuilder();
            sb.append(vc.getPrefix());
            try {
                delimiter.escape(entry.getKey(), sb);
                if (entry.getValue().booleanValue()) {
                    sb.append(completion.getDelimiter().getValue());
                }
                candidates.add(sb.toString());
            }
            catch (IOException ignore) {}
        }
        return cursor - vc.getPrefix().length();
    }

    public void cancel() {
        ShellProcess process = this.current.get();
        if (process != null) {
            process.cancel();
        }
    }

    String getPrompt() {
        String prompt = this.shell.getPrompt();
        return prompt == null ? "% " : prompt;
    }
}

