/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.MethodDescriptor;
import org.crsh.cmdline.matcher.CmdCompletionException;
import org.crsh.cmdline.matcher.impl.Completion;
import org.crsh.cmdline.spi.Completion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodCompletion<T>
extends Completion {
    private final ClassDescriptor<T> descriptor;
    private final String mainName;
    private final String prefix;
    private final Delimiter delimiter;

    MethodCompletion(ClassDescriptor<T> descriptor, String mainName, String prefix, Delimiter delimiter) {
        this.descriptor = descriptor;
        this.mainName = mainName;
        this.prefix = prefix;
        this.delimiter = delimiter;
    }

    @Override
    protected CommandCompletion complete() throws CmdCompletionException {
        Completion.Builder builder = org.crsh.cmdline.spi.Completion.builder(this.prefix);
        for (MethodDescriptor<T> m : this.descriptor.getMethods()) {
            String name = m.getName();
            if (!name.startsWith(this.prefix) || name.equals(this.mainName)) continue;
            builder.add(name.substring(this.prefix.length()), true);
        }
        return new CommandCompletion(this.delimiter, builder.build());
    }
}

