/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import groovy.lang.GroovyShell;
import java.util.Arrays;
import java.util.List;
import org.crsh.AbstractTestCase;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.text.ui.BorderStyle;
import org.crsh.text.ui.EvalElement;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.Layout;
import org.crsh.text.ui.RowElement;
import org.crsh.text.ui.TableElement;
import org.crsh.text.ui.TreeElement;
import org.crsh.text.ui.UIBuilder;

public class UIBuilderTestCase
extends AbstractTestCase {
    public UIBuilderTestCase() {
    }

    public UIBuilderTestCase(String name) {
        super(name);
    }

    public void testEmptyTable() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)0, (int)res.getElements().size());
    }

    public void testNode() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.node { };\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertNull((Object)((TreeElement)res.getElements().get(0)).getValue());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TreeElement));
        UIBuilderTestCase.assertEquals((int)0, (int)((TreeElement)res.getElements().get(0)).getSize());
    }

    public void testLabelledNode() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.node('foo') { };\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TreeElement));
        UIBuilderTestCase.assertTrue((boolean)(((TreeElement)res.getElements().get(0)).getValue() instanceof LabelElement));
        UIBuilderTestCase.assertEquals((String)"foo", (String)((LabelElement)((TreeElement)res.getElements().get(0)).getValue()).getValue());
        UIBuilderTestCase.assertEquals((int)0, (int)((TreeElement)res.getElements().get(0)).getSize());
    }

    public void testLabel() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.label('foo');\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof LabelElement));
        UIBuilderTestCase.assertEquals((String)"foo", (String)((LabelElement)res.getElements().get(0)).getValue());
    }

    public void testTable() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.table { };\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertEquals((int)0, (int)((TableElement)res.getElements().get(0)).getRows().size());
    }

    public void testEmptyRow() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.table {\nrow { }\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertEquals((int)1, (int)((TableElement)res.getElements().get(0)).getRows().size());
        UIBuilderTestCase.assertEquals((int)0, (int)((RowElement)((TableElement)res.getElements().get(0)).getRows().get(0)).getSize());
    }

    public void testRow() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.table {\nrow () {\nlabel(\"col1\"); label(\"col2\")\n}\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertEquals((int)1, (int)((TableElement)res.getElements().get(0)).getRows().size());
        UIBuilderTestCase.assertEquals((int)2, (int)((RowElement)((TableElement)res.getElements().get(0)).getRows().get(0)).getSize());
        UIBuilderTestCase.assertEquals((String)"Label[col1]", (String)((RowElement)((TableElement)res.getElements().get(0)).getRows().get(0)).getCol(0).toString());
        UIBuilderTestCase.assertEquals((String)"Label[col2]", (String)((RowElement)((TableElement)res.getElements().get(0)).getRows().get(0)).getCol(1).toString());
    }

    public void testRowStyleWithEnd() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\nimport org.crsh.text.Color;\nimport org.crsh.text.Style;\ndef builder = new UIBuilder();\nbuilder.table {\nrow (bold: true, foreground: red, background: green) {\nlabel(\"col1\"); label(\"col2\")\n}\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        TableElement table = UIBuilderTestCase.assertInstance(TableElement.class, res.getElements().get(0));
        UIBuilderTestCase.assertEquals((int)1, (int)table.getRows().size());
        UIBuilderTestCase.assertEquals((int)2, (int)((RowElement)table.getRows().get(0)).getSize());
        UIBuilderTestCase.assertEquals((Object)Decoration.bold.fg(Color.red).bg(Color.green), (Object)((RowElement)table.getRows().get(0)).getStyle());
    }

    public void testTableCols() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.table(columns: [1,1]) {\nrow {\n}\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        TableElement table = UIBuilderTestCase.assertInstance(TableElement.class, res.getElements().get(0));
        Layout.Weighted layout = UIBuilderTestCase.assertInstance(Layout.Weighted.class, table.getColumnLayout());
        UIBuilderTestCase.assertTrue((boolean)Arrays.equals(new int[]{1, 1}, layout.getWeights()));
    }

    public void testTableBorderTrue() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.table(border: true) {\nrow {\n}\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertSame((Object)BorderStyle.DASHED, (Object)((TableElement)res.getElements().get((int)0)).border);
    }

    public void testTableBorderFalse() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.table(border: false) {\nrow {\n}\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertSame(null, (Object)((TableElement)res.getElements().get((int)0)).border);
    }

    public void testTableBorderNull() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.table(border: null) {\nrow {\n}\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertSame(null, (Object)((TableElement)res.getElements().get((int)0)).border);
    }

    public void testTableBorderDash() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.table(border:org.crsh.text.ui.BorderStyle.DASHED) {\nrow {\n}\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertSame((Object)BorderStyle.DASHED, (Object)((TableElement)res.getElements().get((int)0)).border);
    }

    public void testTableBorderStar() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder\ndef builder = new UIBuilder();\nbuilder.table(border: org.crsh.text.ui.BorderStyle.STAR) {\nrow {\n}\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertSame((Object)BorderStyle.STAR, (Object)((TableElement)res.getElements().get((int)0)).border);
    }

    public void testTableHeader() {
        GroovyShell shell = new GroovyShell();
        UIBuilder res = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\ndef builder = new UIBuilder();\nbuilder.table {\nheader () {\n}\n};\nreturn builder;\n");
        UIBuilderTestCase.assertEquals((int)1, (int)res.getElements().size());
        UIBuilderTestCase.assertTrue((boolean)(res.getElements().get(0) instanceof TableElement));
        UIBuilderTestCase.assertEquals((int)1, (int)((TableElement)res.getElements().get(0)).getRows().size());
        UIBuilderTestCase.assertEquals((boolean)true, (boolean)((RowElement)((TableElement)res.getElements().get((int)0)).getRows().get((int)0)).header);
    }

    public void testForbiddenChild() throws Exception {
        GroovyShell shell = new GroovyShell();
        try {
            shell.evaluate("import org.crsh.text.ui.UIBuilder;\nimport org.crsh.text.Color;\nimport org.crsh.text.Style;\ndef builder = new UIBuilder();\nbuilder.table {\nrow() {\nnode()\n}\n};\nreturn builder;\n");
            UIBuilderTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            UIBuilderTestCase.assertEquals((String)"A table cannot contain a tree element", (String)iae.getMessage());
        }
    }

    public void testEval() {
        GroovyShell shell = new GroovyShell();
        UIBuilder builder = (UIBuilder)shell.evaluate("import org.crsh.text.ui.UIBuilder;\nimport org.crsh.text.Color;\nimport org.crsh.text.Style;\ndef builder = new UIBuilder();\nbuilder.table {\nrow {\nexecute { return 'HELLO';}\n}\n};\nreturn builder;\n");
        List elements = builder.getElements();
        UIBuilderTestCase.assertEquals((int)1, (int)elements.size());
        TableElement table = UIBuilderTestCase.assertInstance(TableElement.class, elements.get(0));
        UIBuilderTestCase.assertEquals((int)1, (int)table.getRows().size());
        RowElement row = (RowElement)table.getRows().get(0);
        UIBuilderTestCase.assertEquals((int)1, (int)row.getSize());
        EvalElement eval = UIBuilderTestCase.assertInstance(EvalElement.class, row.getCol(0));
        UIBuilderTestCase.assertNotNull((Object)eval.closure);
        UIBuilderTestCase.assertEquals((Object)"HELLO", (Object)eval.closure.call());
    }
}

