/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs;

import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import junit.framework.TestCase;
import org.crsh.util.IO;
import org.crsh.vfs.FS;
import org.crsh.vfs.File;
import org.crsh.vfs.Path;
import org.crsh.vfs.spi.jarurl.Handle;
import org.crsh.vfs.spi.jarurl.JarURLDriver;
import org.crsh.vfs.spi.ram.RAMDriver;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class FSTestCase
extends TestCase {
    public void testFoo() throws Exception {
        FS fs = new FS().mount(FSTestCase.class);
        File root = fs.get(Path.get((String)"/"));
        File org = root.child("org", true);
        FSTestCase.assertEquals((String)"org", (String)org.getName());
        FSTestCase.assertEquals((boolean)true, (boolean)org.isDir());
        Iterator orgChildren = org.children().iterator();
        File crsh = (File)orgChildren.next();
        FSTestCase.assertFalse((boolean)orgChildren.hasNext());
        FSTestCase.assertEquals((String)"crsh", (String)crsh.getName());
        FSTestCase.assertEquals((boolean)true, (boolean)crsh.isDir());
    }

    public void testJar() throws Exception {
        java.io.File file = java.io.File.createTempFile("test", ".jar");
        file.deleteOnExit();
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        archive.addClass(FSTestCase.class);
        ZipExporter exporter = (ZipExporter)archive.as(ZipExporter.class);
        exporter.exportTo(file, true);
        URLClassLoader cl = new URLClassLoader(new URL[]{file.toURI().toURL()});
        URL classURL = cl.findResource(FSTestCase.class.getName().replace('.', '/') + ".class");
        JarURLConnection conn = (JarURLConnection)classURL.openConnection();
        JarURLDriver driver = new JarURLDriver((ClassLoader)cl, conn);
        Handle root = driver.root();
        FSTestCase.assertEquals((String)"", (String)driver.name(root));
        FSTestCase.assertTrue((boolean)driver.isDir(root));
        Iterator rootChildren = driver.children(root).iterator();
        Handle org = (Handle)rootChildren.next();
        FSTestCase.assertFalse((boolean)rootChildren.hasNext());
        FSTestCase.assertEquals((String)"org", (String)driver.name(org));
        FSTestCase.assertTrue((boolean)driver.isDir(org));
        Iterator orgChildren = driver.children(org).iterator();
        Handle crsh = (Handle)orgChildren.next();
        FSTestCase.assertFalse((boolean)orgChildren.hasNext());
        FSTestCase.assertEquals((String)"crsh", (String)driver.name(crsh));
        FSTestCase.assertTrue((boolean)driver.isDir(crsh));
        Iterator vfsChildren = driver.children(crsh).iterator();
        Handle vfs = (Handle)vfsChildren.next();
        FSTestCase.assertFalse((boolean)vfsChildren.hasNext());
        FSTestCase.assertEquals((String)"vfs", (String)driver.name(vfs));
        FSTestCase.assertTrue((boolean)driver.isDir(vfs));
        Iterator clazzChildren = driver.children(vfs).iterator();
        Handle clazz = (Handle)clazzChildren.next();
        FSTestCase.assertFalse((boolean)clazzChildren.hasNext());
        FSTestCase.assertEquals((String)(FSTestCase.class.getSimpleName() + ".class"), (String)driver.name(clazz));
        FSTestCase.assertFalse((boolean)driver.isDir(clazz));
        InputStream in = driver.open(clazz);
        in.close();
    }

    public void testRAM() throws Exception {
        RAMDriver driver = new RAMDriver();
        driver.add("/foo", "bar");
        Path root = driver.root();
        FSTestCase.assertEquals((Object)Path.get((String)"/"), (Object)root);
        Path foo = (Path)driver.child((Object)root, "foo");
        FSTestCase.assertNotNull((Object)foo);
        InputStream in = driver.open(foo);
        String file = IO.readAsUTF8((InputStream)in);
        FSTestCase.assertEquals((String)"bar", (String)file);
    }
}

