/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.IntrospectionException;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.annotations.Man;
import org.crsh.cmdline.annotations.Option;
import org.crsh.cmdline.annotations.Usage;
import org.crsh.cmdline.matcher.ClassMatch;
import org.crsh.cmdline.matcher.CmdCompletionException;
import org.crsh.cmdline.matcher.CmdInvocationException;
import org.crsh.cmdline.matcher.CmdSyntaxException;
import org.crsh.cmdline.matcher.CommandMatch;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.cmdline.matcher.MethodMatch;
import org.crsh.cmdline.matcher.OptionMatch;
import org.crsh.cmdline.matcher.Resolver;
import org.crsh.cmdline.spi.Completer;
import org.crsh.cmdline.spi.Completion;
import org.crsh.command.CommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.command.DescriptionFormat;
import org.crsh.command.GroovyCommand;
import org.crsh.command.InvocationContext;
import org.crsh.command.InvocationContextImpl;
import org.crsh.command.PipeCommand;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.command.SyntaxException;
import org.crsh.io.ProducerContext;
import org.crsh.util.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CRaSHCommand
extends GroovyCommand
implements ShellCommand {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ClassDescriptor<?> descriptor = new CommandFactory(this.getClass().getClassLoader()).create(this.getClass());
    protected String unmatched = null;
    @Option(names={"h", "help"})
    @Usage(value="command usage")
    @Man(value="Provides command usage")
    private boolean help = false;

    protected CRaSHCommand() throws IntrospectionException {
    }

    public ClassDescriptor<?> getDescriptor() {
        return this.descriptor;
    }

    protected final String readLine(String msg) {
        return this.readLine(msg, true);
    }

    protected final String readLine(String msg, boolean echo) {
        if (this.context instanceof InvocationContext) {
            return ((InvocationContext)this.context).readLine(msg, echo);
        }
        throw new IllegalStateException("Cannot invoke read line without an invocation context");
    }

    public final String getUnmatched() {
        return this.unmatched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CommandCompletion complete(CommandContext context, String line) {
        Matcher analyzer = this.descriptor.matcher("main");
        Completer completer = this instanceof Completer ? (Completer)this : null;
        this.context = context;
        try {
            CommandCompletion commandCompletion = analyzer.complete(completer, line);
            return commandCompletion;
        }
        catch (CmdCompletionException e) {
            this.log.error("Error during completion of line " + line, (Throwable)e);
            CommandCompletion commandCompletion = new CommandCompletion(Delimiter.EMPTY, Completion.create());
            return commandCompletion;
        }
        finally {
            this.context = null;
        }
    }

    @Override
    public final String describe(String line, DescriptionFormat mode) {
        Matcher analyzer = this.descriptor.matcher("main");
        CommandMatch match = analyzer.match(line);
        try {
            switch (mode) {
                case DESCRIBE: {
                    return match.getDescriptor().getUsage();
                }
                case MAN: {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    match.printMan((Appendable)pw);
                    return sw.toString();
                }
                case USAGE: {
                    StringWriter sw2 = new StringWriter();
                    PrintWriter pw2 = new PrintWriter(sw2);
                    match.printUsage((Appendable)pw2);
                    return sw2.toString();
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return null;
    }

    static ScriptException toScript(Throwable cause) {
        if (cause instanceof ScriptException) {
            return (ScriptException)cause;
        }
        if (cause instanceof groovy.util.ScriptException) {
            String msg = cause.getMessage();
            ScriptException translated = msg != null ? new ScriptException(msg) : new ScriptException();
            translated.setStackTrace(cause.getStackTrace());
            return translated;
        }
        return new ScriptException(cause);
    }

    @Override
    public CommandInvoker<?, ?> resolveInvoker(String name, Map<String, ?> options, List<?> args) {
        if (options.containsKey("h") || options.containsKey("help")) {
            throw new UnsupportedOperationException("Implement me");
        }
        Matcher matcher = this.descriptor.matcher("main");
        CommandMatch match = matcher.match(name, options, args);
        return this.resolveInvoker(match);
    }

    @Override
    public CommandInvoker<?, ?> resolveInvoker(String line) {
        Matcher analyzer = this.descriptor.matcher("main");
        CommandMatch match = analyzer.match(line);
        return this.resolveInvoker(match);
    }

    public final void execute(String s) throws ScriptException, IOException {
        InvocationContext<?> context = this.peekContext();
        CommandInvoker<?, ?> invoker = context.resolve(s);
        invoker.open(context);
        invoker.flush();
        invoker.close();
    }

    public final CommandInvoker<?, ?> resolveInvoker(final CommandMatch<CRaSHCommand, ?, ?> match) {
        if (match instanceof MethodMatch) {
            Class producedType;
            Class consumedType;
            final MethodMatch methodMatch = (MethodMatch)match;
            boolean help = false;
            for (OptionMatch optionMatch : methodMatch.getOwner().getOptionMatches()) {
                OptionDescriptor optionDesc;
                ParameterDescriptor parameterDesc = optionMatch.getParameter();
                if (!(parameterDesc instanceof OptionDescriptor) || !(optionDesc = (OptionDescriptor)parameterDesc).getNames().contains("h")) continue;
                help = true;
            }
            boolean doHelp = help;
            Method m = methodMatch.getDescriptor().getMethod();
            if (PipeCommand.class.isAssignableFrom(m.getReturnType())) {
                Type ret = m.getGenericReturnType();
                consumedType = TypeResolver.resolveToClass(ret, PipeCommand.class, 0);
                producedType = TypeResolver.resolveToClass(ret, PipeCommand.class, 1);
            } else {
                consumedType = Void.class;
                producedType = Object.class;
                Class<?>[] parameterTypes = m.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> parameterType = parameterTypes[i];
                    if (!InvocationContext.class.isAssignableFrom(parameterType)) continue;
                    Type contextGenericParameterType = m.getGenericParameterTypes()[i];
                    producedType = TypeResolver.resolveToClass(contextGenericParameterType, InvocationContext.class, 0);
                    break;
                }
            }
            final Class _consumedType = consumedType;
            final Class _producedType = producedType;
            if (doHelp) {
                return new CommandInvoker<Object, Object>(){
                    private CommandContext session;
                    private InvocationContextImpl context;

                    @Override
                    public Class<Object> getProducedType() {
                        return _producedType;
                    }

                    @Override
                    public void setSession(CommandContext session) {
                        this.session = session;
                    }

                    @Override
                    public Class<Object> getConsumedType() {
                        return _consumedType;
                    }

                    @Override
                    public void open(ProducerContext<Object> context) {
                        this.context = new InvocationContextImpl<Object>(context, this.session);
                        try {
                            match.printUsage((Appendable)this.context.getWriter());
                        }
                        catch (IOException e) {
                            throw new AssertionError((Object)e);
                        }
                    }

                    @Override
                    public void setPiped(boolean piped) {
                    }

                    @Override
                    public void provide(Object element) throws IOException {
                    }

                    @Override
                    public void flush() throws IOException {
                        this.context.flush();
                    }

                    @Override
                    public void close() {
                    }
                };
            }
            if (consumedType == Void.class) {
                return new CommandInvoker<Object, Object>(){
                    private CommandContext session;

                    @Override
                    public void setSession(CommandContext session) {
                        this.session = session;
                    }

                    @Override
                    public Class<Object> getProducedType() {
                        return _producedType;
                    }

                    @Override
                    public Class<Object> getConsumedType() {
                        return _consumedType;
                    }

                    @Override
                    public void open(ProducerContext<Object> context) {
                        Object o;
                        CRaSHCommand.this.pushContext(new InvocationContextImpl<Object>(context, this.session));
                        CRaSHCommand.this.unmatched = methodMatch.getRest();
                        Resolver resolver = new Resolver(){

                            public <T> T resolve(Class<T> type) {
                                if (type.equals(InvocationContext.class)) {
                                    return type.cast(CRaSHCommand.this.peekContext());
                                }
                                return null;
                            }
                        };
                        try {
                            o = methodMatch.invoke(resolver, (Object)CRaSHCommand.this);
                        }
                        catch (CmdSyntaxException e) {
                            throw new SyntaxException(e.getMessage());
                        }
                        catch (CmdInvocationException e) {
                            throw CRaSHCommand.toScript(e.getCause());
                        }
                        if (o != null) {
                            CRaSHCommand.this.peekContext().getWriter().print(o);
                        }
                    }

                    @Override
                    public void setPiped(boolean piped) {
                    }

                    @Override
                    public void provide(Object element) throws IOException {
                    }

                    @Override
                    public void flush() throws IOException {
                        CRaSHCommand.this.peekContext().flush();
                    }

                    @Override
                    public void close() {
                        CRaSHCommand.this.unmatched = null;
                        CRaSHCommand.this.popContext();
                    }
                };
            }
            return new CommandInvoker<Object, Object>(){
                PipeCommand real;
                boolean piped;
                private CommandContext session;

                @Override
                public Class<Object> getProducedType() {
                    return _producedType;
                }

                @Override
                public Class<Object> getConsumedType() {
                    return _consumedType;
                }

                @Override
                public void setSession(CommandContext session) {
                    this.session = session;
                }

                @Override
                public void setPiped(boolean piped) {
                    this.piped = piped;
                }

                @Override
                public void open(ProducerContext<Object> context) {
                    final InvocationContextImpl<Object> invocationContext = new InvocationContextImpl<Object>(context, this.session);
                    CRaSHCommand.this.pushContext(invocationContext);
                    CRaSHCommand.this.unmatched = methodMatch.getRest();
                    Resolver resolver = new Resolver(){

                        public <T> T resolve(Class<T> type) {
                            if (type.equals(InvocationContext.class)) {
                                return type.cast(invocationContext);
                            }
                            return null;
                        }
                    };
                    try {
                        this.real = (PipeCommand)methodMatch.invoke(resolver, (Object)CRaSHCommand.this);
                    }
                    catch (CmdSyntaxException e) {
                        throw new SyntaxException(e.getMessage());
                    }
                    catch (CmdInvocationException e) {
                        throw CRaSHCommand.toScript(e.getCause());
                    }
                    this.real.setPiped(this.piped);
                    this.real.doOpen(invocationContext);
                }

                @Override
                public void provide(Object element) throws IOException {
                    this.real.provide(element);
                }

                @Override
                public void flush() throws IOException {
                    this.real.flush();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    try {
                        this.real.close();
                    }
                    finally {
                        CRaSHCommand.this.popContext();
                    }
                }
            };
        }
        if (match instanceof ClassMatch) {
            final ClassMatch classMatch = (ClassMatch)match;
            boolean help = false;
            for (OptionMatch optionMatch : classMatch.getOptionMatches()) {
                OptionDescriptor optionDesc;
                ParameterDescriptor parameterDesc = optionMatch.getParameter();
                if (!(parameterDesc instanceof OptionDescriptor) || !(optionDesc = (OptionDescriptor)parameterDesc).getNames().contains("h")) continue;
                help = true;
            }
            final boolean doHelp = help;
            return new CommandInvoker<Void, Object>(){
                private CommandContext session;
                InvocationContext context;

                @Override
                public void open(ProducerContext<Object> producerContext) {
                    this.context = new InvocationContextImpl<Object>(producerContext, this.session);
                    try {
                        if (doHelp) {
                            match.printUsage((Appendable)this.context.getWriter());
                        } else {
                            classMatch.printUsage((Appendable)this.context.getWriter());
                        }
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                }

                @Override
                public void setSession(CommandContext session) {
                    this.session = session;
                }

                @Override
                public void setPiped(boolean piped) {
                }

                @Override
                public void close() {
                    this.context = null;
                }

                @Override
                public void provide(Void element) throws IOException {
                }

                @Override
                public void flush() throws IOException {
                    this.context.flush();
                }

                @Override
                public Class<Object> getProducedType() {
                    return Object.class;
                }

                @Override
                public Class<Void> getConsumedType() {
                    return Void.class;
                }
            };
        }
        return null;
    }
}

