/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.processor.jline;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.crsh.processor.jline.JLineProcessor;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.text.Chunk;
import org.crsh.text.Style;
import org.crsh.text.Text;

class JLineProcessContext
implements ShellProcessContext {
    private static final Character NO_ECHO = Character.valueOf('\u0000');
    final JLineProcessor processor;
    final CountDownLatch latch = new CountDownLatch(1);
    final AtomicReference<ShellResponse> resp = new AtomicReference();

    public JLineProcessContext(JLineProcessor processor) {
        this.processor = processor;
    }

    public boolean takeAlternateBuffer() {
        if (!this.processor.useAlternate) {
            this.processor.useAlternate = true;
            this.processor.writer.print("\u001b[?47h");
        }
        return true;
    }

    public boolean releaseAlternateBuffer() {
        if (this.processor.useAlternate) {
            this.processor.useAlternate = false;
            this.processor.writer.print("\u001b[?47l");
        }
        return true;
    }

    public int getWidth() {
        return this.processor.reader.getTerminal().getWidth();
    }

    public int getHeight() {
        return this.processor.reader.getTerminal().getHeight();
    }

    public String getProperty(String name) {
        return null;
    }

    public String readLine(String msg, boolean echo) {
        try {
            if (echo) {
                return this.processor.reader.readLine(msg);
            }
            return this.processor.reader.readLine(msg, NO_ECHO);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void provide(Chunk element) throws IOException {
        if (element instanceof Text) {
            Text textChunk = (Text)element;
            this.processor.writer.append(textChunk.getText());
        } else if (element instanceof Style) {
            try {
                ((Style)element).writeAnsiTo(this.processor.writer);
            }
            catch (IOException iOException) {}
        } else {
            this.processor.writer.print("\u001b[2J");
            this.processor.writer.print("\u001b[1;1H");
        }
    }

    public void flush() {
        this.processor.writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ShellResponse response) {
        try {
            this.resp.set(response);
            this.latch.countDown();
        }
        finally {
            this.releaseAlternateBuffer();
        }
    }
}

