/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import org.crsh.shell.AbstractCommandTestCase;

public class EvalTestCase
extends AbstractCommandTestCase {
    public void testProvideRenderable() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n  @Command\n  public void main() {\n    def builder = new org.crsh.text.ui.UIBuilder().eval {      bar()\n    }\n    out << builder\n  }\n}";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("bar", "context.provide([a:1]);");
        EvalTestCase.assertEquals((String)"a                               \n--                              \n1                               \n", (String)this.assertOk("foo"));
    }

    public void testProvideText() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n  @Command\n  public void main() {\n    def builder = new org.crsh.text.ui.UIBuilder().eval {      bar()\n    }\n    out << builder\n  }\n}";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("bar", "out << 'hello';");
        EvalTestCase.assertEquals((String)"hello                           \n", (String)this.assertOk("foo"));
    }

    public void testEvalCommandInEval() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n  @Command\n  public void main() {\n    def builder = new org.crsh.text.ui.UIBuilder().eval {      execute('echo bar')\n    }\n    out << builder\n  }\n}";
        this.lifeCycle.bind("foo", foo);
        EvalTestCase.assertEquals((String)"bar                             \n", (String)this.assertOk("foo"));
    }

    public void testEvalCommandInCommand() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n  @Command\n  public void main() {\n    execute('echo bar')\n  }\n}";
        this.lifeCycle.bind("foo", foo);
        EvalTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testContextLeftShift() {
        String bar = "context << 'juu'\nreturn null";
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n  @Command\n  public void main() {\n    execute('bar')\n  }\n}";
        this.lifeCycle.bind("bar", bar);
        this.lifeCycle.bind("foo", foo);
        EvalTestCase.assertEquals((String)"juu", (String)this.assertOk("foo"));
    }
}

