/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final Pattern FOO = Pattern.compile("(\\*)|(\\?)|(?:\\[([^)]+)\\])|(\\\\.)");

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V, M extends Map<K, V>> M map(M map, K key, V value) {
        map.put(key, value);
        return map;
    }

    public static <K, V> HashMap<K, V> map(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    public static <E> List<E> list(E ... elements) {
        return Arrays.asList(elements);
    }

    public static <E> List<E> list(Iterable<E> iterable) {
        return Utils.list(iterable.iterator());
    }

    public static <E> List<E> list(Iterator<E> iterator) {
        ArrayList<E> list = new ArrayList<E>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static int indexOf(CharSequence s, int off, char c) {
        int len = s.length();
        while (off < len) {
            if (s.charAt(off) == c) {
                return off;
            }
            ++off;
        }
        return -1;
    }

    public static String trimLeft(String s) {
        int index;
        if (s == null) {
            throw new NullPointerException("No null string accepted");
        }
        int len = s.length();
        for (index = 0; index < len && s.charAt(index) == ' '; ++index) {
        }
        if (index > 0) {
            return s.substring(index);
        }
        return s;
    }

    public static <E> E notNull(E e1, E e2) {
        if (e1 != null) {
            return e1;
        }
        return e2;
    }

    public static String globexToRegex(String globex) throws NullPointerException {
        if (globex == null) {
            throw new NullPointerException("No null globex accepted");
        }
        StringBuilder regex = new StringBuilder();
        int prev = 0;
        Matcher matcher = FOO.matcher(globex);
        while (matcher.find()) {
            int next = matcher.start();
            if (next > prev) {
                regex.append(Pattern.quote(globex.substring(prev, next)));
            }
            if (matcher.group(1) != null) {
                regex.append(".*");
            } else if (matcher.group(2) != null) {
                regex.append(".");
            } else if (matcher.group(3) != null) {
                regex.append("[");
                regex.append(Pattern.quote(matcher.group(3)));
                regex.append("]");
            } else if (matcher.group(4) != null) {
                regex.append(Pattern.quote(Character.toString(matcher.group(4).charAt(1))));
            } else {
                throw new UnsupportedOperationException("Not handled yet");
            }
            prev = matcher.end();
        }
        if (prev < globex.length()) {
            regex.append(Pattern.quote(globex.substring(prev)));
        }
        return regex.toString();
    }
}

