/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.awt.AWTError;
import java.util.EmptyStackException;
import javax.management.JMException;
import org.crsh.command.ScriptException;
import org.crsh.shell.AbstractCommandTestCase;

public class CommandTestCase
extends AbstractCommandTestCase {
    private final String no_ret = "class no_ret extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\n}\n}";

    public void testUnknownCommand() throws Exception {
        this.assertUnknownCommand("bilto");
    }

    public void testFailure() throws Exception {
        Throwable t = this.assertEvalError("fail");
    }

    public void testInvalid() throws Exception {
        this.assertUnknownCommand("invalid");
    }

    public void testSimple() throws Exception {
        CommandTestCase.assertEquals((String)"foo", (String)this.assertOk("echo foo"));
    }

    public void testSession() throws Exception {
        CommandTestCase.assertEquals((String)"null", (String)this.assertOk("attribute foo"));
        this.lifeCycle.setAttribute("foo", "bar");
        CommandTestCase.assertEquals((String)"bar", (String)this.assertOk("attribute foo"));
        this.lifeCycle.setAttribute("foo", null);
        CommandTestCase.assertEquals((String)"null", (String)this.assertOk("attribute foo"));
    }

    public void testInvokeNoRet() throws Exception {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\nno_ret()\n}\n}";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("no_ret", "class no_ret extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\n}\n}");
        CommandTestCase.assertEquals((String)"", (String)this.assertOk("foo"));
    }

    public void testInvokeNoRetInScript() throws Exception {
        String foo = "no_ret()\n";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("no_ret", "class no_ret extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\n}\n}");
        CommandTestCase.assertEquals((String)"", (String)this.assertOk("foo"));
    }

    public void testInvoke() throws Exception {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic String main() {\necho 'bar'\n}\n}";
        this.lifeCycle.bind("foo", foo);
        CommandTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testInvokeInScript() throws Exception {
        String foo = "echo 'bar'\n";
        this.lifeCycle.bind("foo", foo);
        CommandTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testFlush() {
        CommandTestCase.assertEquals((String)"foobar", (String)this.assertOk("echo -f 1 foo bar"));
        CommandTestCase.assertEquals((String)"bar", (String)this.evalOk("out << 'bar'; out.flush();"));
    }

    public void testResolveOut() {
        String resolve = "class resolve extends org.crsh.command.CRaSHCommand {\n@Command\npublic org.crsh.command.PipeCommand<Object, Object> main() {\nreturn new org.crsh.command.PipeCommand<Object, Object>() {\npublic void open() {\nout << 'HELLO'\n}\n}\n}\n}";
        this.lifeCycle.bind("resolve", resolve);
        CommandTestCase.assertEquals((String)"HELLO", (String)this.assertOk("resolve"));
    }

    public void testContextLeftShift() {
        String foo = "class foo extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\ncontext << 'hello'\ncontext << 3\n}\n}";
        this.lifeCycle.bind("foo", foo);
        CommandTestCase.assertEquals((String)"hello3", (String)this.assertOk("foo"));
    }

    public void testScriptContextLeftShift() {
        String foo = "context << 'hello'\ncontext << 3\nreturn null";
        this.lifeCycle.bind("foo", foo);
        CommandTestCase.assertEquals((String)"hello3", (String)this.assertOk("foo"));
    }

    public void testThrowScript() throws Exception {
        this.lifeCycle.bind("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws org.crsh.command.ScriptException {\nthrow new org.crsh.command.ScriptException()}\n}\n");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testThrowGroovyScript() throws Exception {
        this.lifeCycle.bind("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws groovy.util.ScriptException {\nthrow new groovy.util.ScriptException()}\n}\n");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testThrowCheckedException() throws Exception {
        this.lifeCycle.bind("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws javax.management.JMException {\nthrow new javax.management.JMException()}\n}\n");
        this.assertEvalError("a", JMException.class);
    }

    public void testThrowRuntimeException() throws Exception {
        this.lifeCycle.bind("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws java.util.EmptyStackException {\nthrow new java.util.EmptyStackException()}\n}\n");
        this.assertEvalError("a", EmptyStackException.class);
    }

    public void testThrowError() throws Exception {
        this.lifeCycle.bind("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() throws java.awt.AWTError {\nthrow new java.awt.AWTError()}\n}\n");
        this.assertInternalError("a", AWTError.class);
    }

    public void testUndeclaredThrowScript() throws Exception {
        this.lifeCycle.bind("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new org.crsh.command.ScriptException()}\n}\n");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testUndeclaredThrowGroovyScript() throws Exception {
        this.lifeCycle.bind("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new groovy.util.ScriptException()}\n}\n");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testUndeclaredThrowCheckedException() throws Exception {
        this.lifeCycle.bind("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new javax.management.JMException()}\n}\n");
        this.assertEvalError("a", JMException.class);
    }

    public void testUndeclaredThrowRuntimeException() throws Exception {
        this.lifeCycle.bind("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new java.util.EmptyStackException()}\n}\n");
        this.assertEvalError("a", EmptyStackException.class);
    }

    public void testUndeclaredThrowError() throws Exception {
        this.lifeCycle.bind("a", "public class a extends org.crsh.command.CRaSHCommand {\n@Command\npublic void main() {\nthrow new java.awt.AWTError()}\n}\n");
        this.assertInternalError("a", AWTError.class);
    }

    public void testScriptThrowScript() throws Exception {
        this.lifeCycle.bind("a", "throw new org.crsh.command.ScriptException()");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testScriptThrowGroovyScript() throws Exception {
        this.lifeCycle.bind("a", "throw new groovy.util.ScriptException()");
        this.assertEvalError("a", ScriptException.class);
    }

    public void testScriptThrowCheckedException() throws Exception {
        this.lifeCycle.bind("a", "throw new javax.management.JMException()");
        this.assertEvalError("a", JMException.class);
    }

    public void testScriptThrowRuntimeException() throws Exception {
        this.lifeCycle.bind("a", "throw new java.util.EmptyStackException()");
        this.assertEvalError("a", EmptyStackException.class);
    }

    public void testScriptThrowError() throws Exception {
        this.lifeCycle.bind("a", "throw new java.awt.AWTError()");
        this.assertInternalError("a", AWTError.class);
    }
}

