/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.console;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.crsh.term.CodeType;
import org.crsh.term.spi.TermIO;
import org.crsh.text.Style;

public class SimpleTermIO
implements TermIO {
    private final StringBuilder line = new StringBuilder();
    private int lastPosition = 0;
    private int position = 0;
    private final boolean supportsCursorMove;

    public SimpleTermIO(boolean supportsCursorMove) {
        this.supportsCursorMove = supportsCursorMove;
    }

    public void assertChars(String s) {
        Assert.assertTrue((this.line.length() >= s.length() ? 1 : 0) != 0);
        Assert.assertEquals((String)s, (String)this.line.substring(0, s.length()));
        this.line.delete(0, s.length());
    }

    public void assertEmpty() {
        Assert.assertEquals((String)("Was expecting empty line instead of '" + this.line + "'"), (int)0, (int)this.line.length());
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int getWidth() {
        throw new UnsupportedOperationException();
    }

    public int getHeight() {
        throw new UnsupportedOperationException();
    }

    public String getProperty(String name) {
        throw new UnsupportedOperationException();
    }

    public boolean takeAlternateBuffer() {
        throw new UnsupportedOperationException();
    }

    public boolean releaseAlternateBuffer() {
        throw new UnsupportedOperationException();
    }

    public CodeType decode(int code) {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void flush() throws IOException {
    }

    public void cls() throws IOException {
        this.line.setLength(0);
        this.position = 0;
    }

    public void write(CharSequence s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.write(c);
        }
    }

    public void write(char c) throws IOException {
        if (c == '\r' || c == '\n') {
            throw new AssertionFailedError();
        }
        if (this.position < this.line.length()) {
            this.line.setCharAt(this.position++, c);
        } else {
            this.line.append(c);
            ++this.position;
        }
    }

    public void write(Style style) throws IOException {
    }

    public void writeDel() throws IOException {
        if (this.position <= this.lastPosition) {
            throw new AssertionFailedError();
        }
        this.line.deleteCharAt(--this.position);
    }

    public boolean moveRight(char c) {
        if (this.supportsCursorMove && this.position < this.line.length()) {
            this.line.setCharAt(this.position++, c);
            return true;
        }
        return false;
    }

    public void writeCRLF() throws IOException {
        this.line.append("\r\n");
        this.position += 2;
        this.lastPosition = this.position;
    }

    public boolean moveLeft() {
        if (this.supportsCursorMove) {
            if (this.position > this.lastPosition) {
                --this.position;
            } else {
                throw new AssertionFailedError();
            }
            return true;
        }
        return false;
    }
}

