/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.io.IOException;
import java.util.LinkedList;
import org.crsh.shell.ScreenContext;
import org.crsh.text.Chunk;
import org.crsh.text.Color;
import org.crsh.text.Style;
import org.crsh.text.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderAppendable
implements Appendable,
ScreenContext<Chunk> {
    private final ScreenContext<Chunk> context;
    private LinkedList<Style.Composite> stack;

    public RenderAppendable(ScreenContext<Chunk> context) {
        this.context = context;
    }

    private void safeAppend(Chunk chunk) {
        try {
            this.context.provide(chunk);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Class<Chunk> getConsumedType() {
        return Chunk.class;
    }

    @Override
    public int getWidth() {
        return this.context.getWidth();
    }

    @Override
    public int getHeight() {
        return this.context.getHeight();
    }

    @Override
    public void provide(Chunk element) throws IOException {
        this.context.provide(element);
    }

    @Override
    public void flush() throws IOException {
        this.context.flush();
    }

    @Override
    public RenderAppendable append(CharSequence csq) {
        this.safeAppend(Text.create(csq));
        return this;
    }

    public void enterStyle(Style.Composite style) {
        if (this.stack == null) {
            this.stack = new LinkedList();
        }
        this.safeAppend(style);
        this.stack.addLast(style);
    }

    public Style.Composite leaveStyle() {
        if (this.stack == null || this.stack.isEmpty()) {
            throw new IllegalStateException("Cannot leave non existing style");
        }
        Style.Composite last = this.stack.removeLast();
        if (this.stack.size() > 0) {
            Style.Composite merged = this.getMerged();
            Boolean bold = this.foo(last.getBold(), merged.getBold());
            Boolean underline = this.foo(last.getUnderline(), merged.getUnderline());
            Boolean blink = this.foo(last.getBlink(), merged.getBlink());
            Color fg = this.foo(last.getForeground(), merged.getForeground(), Color.def);
            Color bg = this.foo(last.getBackground(), merged.getBackground(), Color.def);
            Style.Composite bilto = Style.style(bold, underline, blink, fg, bg);
            this.safeAppend(bilto);
        } else {
            this.safeAppend(Style.reset);
        }
        return last;
    }

    private Style.Composite getMerged() {
        Style.Composite merged = Style.style();
        for (Style.Composite s : this.stack) {
            merged = (Style.Composite)merged.merge(s);
        }
        return merged;
    }

    private Boolean foo(Boolean last, Boolean merged) {
        if (last != null) {
            if (merged != null) {
                return merged;
            }
            return last == false;
        }
        return null;
    }

    private Color foo(Color last, Color merged, Color def) {
        if (last != null) {
            if (merged != null) {
                return merged;
            }
            return def;
        }
        return null;
    }

    public void styleOff() {
        if (this.stack != null && this.stack.size() > 0) {
            this.safeAppend(Style.reset);
        }
    }

    public void styleOn() {
        if (this.stack != null && this.stack.size() > 0) {
            this.safeAppend(this.getMerged());
        }
    }

    @Override
    public RenderAppendable append(CharSequence csq, int start, int end) {
        this.safeAppend(Text.create(csq.subSequence(start, end)));
        return this;
    }

    @Override
    public RenderAppendable append(char c) {
        this.safeAppend(Text.create(Character.toString(c)));
        return this;
    }
}

