/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import java.io.IOException;
import org.crsh.text.ui.AbstractRendererTestCase;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.LabelElement;

public class LabelRendererTestCase
extends AbstractRendererTestCase {
    public void testRender() throws IOException {
        this.assertRender((Element)new LabelElement(""), 5, "     ");
        this.assertRender((Element)new LabelElement("\n"), 5, "     ", "     ");
        this.assertRender((Element)new LabelElement("a"), 5, "a    ");
        this.assertRender((Element)new LabelElement("a"), 4, "a   ");
        this.assertRender((Element)new LabelElement("a"), 3, "a  ");
        this.assertRender((Element)new LabelElement("a"), 2, "a ");
        this.assertRender((Element)new LabelElement("a"), 1, "a");
        this.assertNoRender((Element)new LabelElement("a"), 0);
        this.assertRender((Element)new LabelElement("ab"), 1, "a", "b");
        this.assertRender((Element)new LabelElement("bar"), 2, "ba", "r ");
        this.assertRender((Element)new LabelElement("a\nb"), 2, "a ", "b ");
        this.assertRender((Element)new LabelElement("a\nb"), 1, "a", "b");
        this.assertRender((Element)new LabelElement("ABCDEF\n"), 5, "ABCDE", "F    ", "     ");
        this.assertRender((Element)new LabelElement("ABCDEF\nG"), 5, "ABCDE", "F    ", "G    ");
    }

    public void testActualHeight() {
        LabelRendererTestCase.assertEquals((int)1, (int)new LabelElement((String)"").actualHeight);
        LabelRendererTestCase.assertEquals((int)1, (int)new LabelElement((String)"a").actualHeight);
        LabelRendererTestCase.assertEquals((int)2, (int)new LabelElement((String)"\n").actualHeight);
        LabelRendererTestCase.assertEquals((int)2, (int)new LabelElement((String)"\na").actualHeight);
        LabelRendererTestCase.assertEquals((int)2, (int)new LabelElement((String)"a\n").actualHeight);
        LabelRendererTestCase.assertEquals((int)2, (int)new LabelElement((String)"a\nb").actualHeight);
        LabelRendererTestCase.assertEquals((int)3, (int)new LabelElement((String)"a\nb\n").actualHeight);
        LabelRendererTestCase.assertEquals((int)3, (int)new LabelElement((String)"\n\n").actualHeight);
    }

    public void testRenderFixed() {
        LabelElement label = new LabelElement("foo\nbar");
        this.assertRender((Element)label, 2, 5, "fo", "o ", "ba", "r ", "  ");
        this.assertRender((Element)label, 2, 4, "fo", "o ", "ba", "r ");
        this.assertNoRender((Element)label, 2, 3);
        this.assertNoRender((Element)label, 2, 2);
        this.assertNoRender((Element)label, 2, 1);
        this.assertRender((Element)label, 3, 3, "foo", "bar", "   ");
        this.assertRender((Element)label, 3, 2, "foo", "bar");
        this.assertNoRender((Element)label, 3, 1);
        this.assertRender((Element)label, 4, 3, "foo ", "bar ", "    ");
        this.assertRender((Element)label, 4, 2, "foo ", "bar ");
        this.assertNoRender((Element)label, 4, 1);
    }
}

