/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.crsh.shell.InteractionContext;
import org.crsh.shell.ScreenContext;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.impl.command.CRaSHSession;
import org.crsh.text.Chunk;
import org.crsh.text.ChunkAdapter;
import org.crsh.text.ChunkBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CRaSHProcessContext
implements InteractionContext<Chunk>,
Closeable {
    private final CRaSHSession session;
    private final ShellProcessContext processContext;
    private final ChunkAdapter adapter;
    private boolean useAlternateBuffer;

    CRaSHProcessContext(CRaSHSession session, final ShellProcessContext processContext) {
        final ChunkBuffer buffer = new ChunkBuffer(processContext);
        ChunkAdapter adapter = new ChunkAdapter(new ScreenContext<Chunk>(){

            @Override
            public int getWidth() {
                return processContext.getWidth();
            }

            @Override
            public int getHeight() {
                return processContext.getHeight();
            }

            @Override
            public Class<Chunk> getConsumedType() {
                return Chunk.class;
            }

            @Override
            public void provide(Chunk element) throws IOException {
                buffer.provide(element);
            }

            @Override
            public void flush() throws IOException {
                buffer.flush();
            }
        });
        this.session = session;
        this.processContext = processContext;
        this.adapter = adapter;
        this.useAlternateBuffer = false;
    }

    @Override
    public boolean takeAlternateBuffer() throws IOException {
        this.useAlternateBuffer = this.processContext.takeAlternateBuffer();
        return this.useAlternateBuffer;
    }

    @Override
    public boolean releaseAlternateBuffer() throws IOException {
        this.useAlternateBuffer = this.processContext.releaseAlternateBuffer();
        return this.useAlternateBuffer;
    }

    @Override
    public String getProperty(String propertyName) {
        return this.processContext.getProperty(propertyName);
    }

    @Override
    public String readLine(String msg, boolean echo) {
        return this.processContext.readLine(msg, echo);
    }

    @Override
    public int getWidth() {
        return this.adapter.getWidth();
    }

    @Override
    public int getHeight() {
        return this.adapter.getHeight();
    }

    @Override
    public Class<Chunk> getConsumedType() {
        return Chunk.class;
    }

    @Override
    public void provide(Chunk element) throws IOException {
        this.adapter.provide(element);
    }

    @Override
    public void flush() throws IOException {
        this.adapter.flush();
    }

    public Map<String, Object> getSession() {
        return this.session;
    }

    public Map<String, Object> getAttributes() {
        return this.session.crash.getContext().getAttributes();
    }

    @Override
    public void close() throws IOException {
        if (this.useAlternateBuffer) {
            this.releaseAlternateBuffer();
        }
    }
}

