/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.crsh.shell.AbstractCommandTestCase;
import org.crsh.shell.ErrorType;
import org.crsh.shell.entities.Bar;
import org.crsh.shell.entities.Foo;
import org.crsh.shell.entities.Foo2;
import org.crsh.text.formatter.EntityTypeRenderable;

public class JPACommandTestCase
extends AbstractCommandTestCase {
    private String defaultFactory;
    public static List<EntityTypeRenderable.EntityTypeData> output_entity = new ArrayList<EntityTypeRenderable.EntityTypeData>();
    public static List<Map> output_value = new ArrayList<Map>();
    private final String consume_command_entity = "class consume_command_entity {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.EntityTypeRenderable.EntityTypeData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.EntityTypeRenderable.EntityTypeData, Object>() {\npublic void provide(org.crsh.text.formatter.EntityTypeRenderable.EntityTypeData element) {\norg.crsh.shell.JPACommandTestCase.output_entity.add(element)\n}\n}\n}\n}";
    private final String consume_command_value = "class consume_command_value {\n@Command\npublic org.crsh.command.PipeCommand<Map, Object> main() {\nreturn new org.crsh.command.PipeCommand<Map, Object>() {\npublic void provide(Map element) {\norg.crsh.shell.JPACommandTestCase.output_value.add(element)\n}\n}\n}\n}";
    private final Comparator entityComparator = new Comparator<EntityTypeRenderable.EntityTypeData>(){

        @Override
        public int compare(EntityTypeRenderable.EntityTypeData o1, EntityTypeRenderable.EntityTypeData o2) {
            return o1.name.compareTo(o2.name);
        }
    };
    private final Comparator attributeComparator = new Comparator<EntityTypeRenderable.AttributeData>(){

        @Override
        public int compare(EntityTypeRenderable.AttributeData o1, EntityTypeRenderable.AttributeData o2) {
            return o1.name.compareTo(o2.name);
        }
    };

    public void setUp() throws Exception {
        super.setUp();
        this.defaultFactory = System.getProperty("java.naming.factory.initial");
        System.setProperty("java.naming.factory.initial", "org.crsh.shell.factory.JPAInitialContextFactory");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.defaultFactory == null) {
            System.clearProperty("java.naming.factory.initial");
        } else {
            System.setProperty("java.naming.factory.initial", this.defaultFactory);
        }
    }

    public void testOpenClose() throws Exception {
        this.assertError("jpa close", ErrorType.EVALUATION);
        this.assertError("jpa open none", ErrorType.EVALUATION);
        this.assertOk("jpa open testEmf");
        this.assertError("jpa open testEmf", ErrorType.EVALUATION);
        this.assertOk("jpa close");
        this.assertError("jpa close", ErrorType.EVALUATION);
    }

    public void testEntities() throws Exception {
        output_entity.clear();
        this.lifeCycle.bind("consume_command_entity", "class consume_command_entity {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.EntityTypeRenderable.EntityTypeData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.EntityTypeRenderable.EntityTypeData, Object>() {\npublic void provide(org.crsh.text.formatter.EntityTypeRenderable.EntityTypeData element) {\norg.crsh.shell.JPACommandTestCase.output_entity.add(element)\n}\n}\n}\n}");
        this.assertOk("jpa open testEmf");
        this.assertOk("jpa entities | consume_command_entity");
        Collections.sort(output_entity, this.entityComparator);
        JPACommandTestCase.assertEquals((int)3, (int)output_entity.size());
        JPACommandTestCase.assertTrue((boolean)JPACommandTestCase.output_entity.get((int)0).name.endsWith("Bar"));
        JPACommandTestCase.assertEquals((String)"org.crsh.shell.entities.Bar", (String)JPACommandTestCase.output_entity.get((int)0).type);
        JPACommandTestCase.assertEquals((String)"ENTITY", (String)JPACommandTestCase.output_entity.get((int)0).mapping);
        JPACommandTestCase.assertEquals((boolean)false, (boolean)JPACommandTestCase.output_entity.get((int)0).verbose);
        JPACommandTestCase.assertTrue((boolean)JPACommandTestCase.output_entity.get((int)1).name.endsWith("Foo"));
        JPACommandTestCase.assertEquals((String)"org.crsh.shell.entities.Foo", (String)JPACommandTestCase.output_entity.get((int)1).type);
        JPACommandTestCase.assertEquals((String)"ENTITY", (String)JPACommandTestCase.output_entity.get((int)1).mapping);
        JPACommandTestCase.assertEquals((boolean)false, (boolean)JPACommandTestCase.output_entity.get((int)1).verbose);
        this.assertOk("jpa close");
    }

    public void testEntity() throws Exception {
        output_entity.clear();
        this.lifeCycle.bind("consume_command_entity", "class consume_command_entity {\n@Command\npublic org.crsh.command.PipeCommand<org.crsh.text.formatter.EntityTypeRenderable.EntityTypeData, Object> main() {\nreturn new org.crsh.command.PipeCommand<org.crsh.text.formatter.EntityTypeRenderable.EntityTypeData, Object>() {\npublic void provide(org.crsh.text.formatter.EntityTypeRenderable.EntityTypeData element) {\norg.crsh.shell.JPACommandTestCase.output_entity.add(element)\n}\n}\n}\n}");
        this.assertOk("jpa open testEmf");
        this.assertError("jpa entity None", ErrorType.EVALUATION);
        this.assertOk("jpa entity " + Foo.class.getName() + " | consume_command_entity");
        JPACommandTestCase.assertEquals((int)1, (int)output_entity.size());
        JPACommandTestCase.assertTrue((boolean)JPACommandTestCase.output_entity.get((int)0).name.endsWith("Foo"));
        JPACommandTestCase.assertEquals((String)"org.crsh.shell.entities.Foo", (String)JPACommandTestCase.output_entity.get((int)0).type);
        JPACommandTestCase.assertEquals((String)"ENTITY", (String)JPACommandTestCase.output_entity.get((int)0).mapping);
        JPACommandTestCase.assertEquals((boolean)true, (boolean)JPACommandTestCase.output_entity.get((int)0).verbose);
        Collections.sort(JPACommandTestCase.output_entity.get((int)0).attributes, this.attributeComparator);
        JPACommandTestCase.assertEquals((int)4, (int)JPACommandTestCase.output_entity.get((int)0).attributes.size());
        JPACommandTestCase.assertEquals((String)"created", (String)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)1)).name);
        JPACommandTestCase.assertEquals((String)Calendar.class.getName(), (String)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)1)).type);
        JPACommandTestCase.assertEquals((String)"BASIC", (String)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)1)).mapping);
        JPACommandTestCase.assertEquals((boolean)false, (boolean)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)1)).association);
        JPACommandTestCase.assertEquals((boolean)false, (boolean)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)1)).collection);
        JPACommandTestCase.assertEquals((String)"id", (String)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)2)).name);
        JPACommandTestCase.assertEquals((String)Long.class.getName(), (String)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)2)).type);
        JPACommandTestCase.assertEquals((String)"BASIC", (String)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)2)).mapping);
        JPACommandTestCase.assertEquals((boolean)false, (boolean)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)2)).association);
        JPACommandTestCase.assertEquals((boolean)false, (boolean)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)2)).collection);
        JPACommandTestCase.assertEquals((String)"name", (String)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)3)).name);
        JPACommandTestCase.assertEquals((String)String.class.getName(), (String)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)3)).type);
        JPACommandTestCase.assertEquals((String)"BASIC", (String)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)3)).mapping);
        JPACommandTestCase.assertEquals((boolean)false, (boolean)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)3)).association);
        JPACommandTestCase.assertEquals((boolean)false, (boolean)((EntityTypeRenderable.AttributeData)JPACommandTestCase.output_entity.get((int)0).attributes.get((int)3)).collection);
        this.assertOk("jpa close");
    }

    public void testSelect() throws Exception {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"testPU");
        EntityManager em = emf.createEntityManager();
        em.getTransaction().begin();
        em.persist((Object)new Bar());
        em.persist((Object)new Bar());
        em.getTransaction().commit();
        em.getTransaction().begin();
        em.persist((Object)new Foo("foo", Calendar.getInstance()));
        Foo foo = new Foo("bar", Calendar.getInstance());
        foo.setBar((Bar)em.find(Bar.class, (Object)1L));
        em.persist((Object)foo);
        Foo2 foo2 = new Foo2();
        foo2.setBars(Arrays.asList((Bar)em.find(Bar.class, (Object)1L), (Bar)em.find(Bar.class, (Object)2L)));
        em.persist((Object)foo2);
        em.persist((Object)new Foo2());
        em.getTransaction().commit();
        em.close();
        output_value.clear();
        this.lifeCycle.bind("consume_command_value", "class consume_command_value {\n@Command\npublic org.crsh.command.PipeCommand<Map, Object> main() {\nreturn new org.crsh.command.PipeCommand<Map, Object>() {\npublic void provide(Map element) {\norg.crsh.shell.JPACommandTestCase.output_value.add(element)\n}\n}\n}\n}");
        this.assertOk("jpa open testEmf");
        this.assertOk("jpa select f FROM Foo f order by f.id | consume_command_value");
        JPACommandTestCase.assertEquals((int)2, (int)output_value.size());
        JPACommandTestCase.assertEquals((String)"1", (String)output_value.get(0).get("*id").toString());
        JPACommandTestCase.assertEquals((Object)"foo", output_value.get(0).get("name"));
        JPACommandTestCase.assertEquals((Object)"<null>", output_value.get(0).get("bar"));
        JPACommandTestCase.assertNotNull(output_value.get(0).get("created"));
        JPACommandTestCase.assertEquals((String)"2", (String)output_value.get(1).get("*id").toString());
        JPACommandTestCase.assertEquals((Object)"bar", output_value.get(1).get("name"));
        JPACommandTestCase.assertNotNull(output_value.get(1).get("created"));
        JPACommandTestCase.assertNotNull(output_value.get(1).get("bar"));
        JPACommandTestCase.assertEquals((Object)(Bar.class.getName() + "[id=1]"), output_value.get(1).get("bar"));
        output_value.clear();
        this.assertOk("jpa select f FROM Foo2 f order by f.id | consume_command_value");
        JPACommandTestCase.assertEquals((int)2, (int)output_value.size());
        JPACommandTestCase.assertEquals((Object)"1", output_value.get(0).get("*id".toString()));
        JPACommandTestCase.assertEquals((Object)("{" + Bar.class.getName() + "[id=1]," + Bar.class.getName() + "[id=2]}"), output_value.get(0).get("bars"));
        JPACommandTestCase.assertEquals((Object)"2", output_value.get(1).get("*id".toString()));
        JPACommandTestCase.assertEquals((Object)"{}", output_value.get(1).get("bars"));
        this.assertOk("jpa close");
    }
}

