/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term;

import java.io.IOException;
import junit.framework.Assert;
import org.crsh.term.CodeType;

public abstract class IOEvent {
    public final void assertEquals(IOEvent event) {
        Assert.assertEquals((Object)this, (Object)event);
    }

    public static class Error
    extends IOEvent {
        private final IOException cause;

        public Error(IOException cause) {
            this.cause = cause;
        }

        public IOException getCause() {
            return this.cause;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[cause=" + this.cause.getMessage() + "]";
        }
    }

    public static class IO
    extends IOEvent {
        private final int code;
        private final CodeType type;

        public IO(char c) {
            this(c, CodeType.CHAR);
        }

        public IO(CodeType type) {
            this(-1, type);
            if (type == CodeType.CHAR) {
                throw new IllegalArgumentException();
            }
        }

        public IO(int code, CodeType type) {
            this.code = code;
            this.type = type;
        }

        public int getCode() {
            return this.code;
        }

        public CodeType getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IO) {
                IO that = (IO)obj;
                if (this.type == that.type) {
                    return this.type != CodeType.CHAR || this.code == that.code;
                }
            }
            return false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[code=" + this.code + ",type=" + this.type + "]";
        }
    }
}

