/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import junit.framework.TestCase;
import org.crsh.util.Safe;

public class SafeTestCase
extends TestCase {
    public void testClose() {
        boolean closed = Safe.close((Closeable)new Closeable(){

            public void close() throws IOException {
            }
        });
        SafeTestCase.assertTrue((boolean)closed);
        closed = Safe.close((Closeable)new Closeable(){

            public void close() throws IOException {
                throw new IOException();
            }
        });
        SafeTestCase.assertFalse((boolean)closed);
        closed = Safe.close((Closeable)new Closeable(){

            public void close() throws IOException {
                throw new RuntimeException();
            }
        });
        SafeTestCase.assertFalse((boolean)closed);
        final Error thrown = new Error();
        try {
            Safe.close((Closeable)new Closeable(){

                public void close() throws IOException {
                    throw thrown;
                }
            });
        }
        catch (Error caught) {
            SafeTestCase.assertSame((Object)thrown, (Object)caught);
        }
    }

    public void testFlush() {
        boolean flushed = Safe.flush((Flushable)new Flushable(){

            public void flush() throws IOException {
            }
        });
        SafeTestCase.assertTrue((boolean)flushed);
        flushed = Safe.flush((Flushable)new Flushable(){

            public void flush() throws IOException {
                throw new IOException();
            }
        });
        SafeTestCase.assertFalse((boolean)flushed);
        flushed = Safe.flush((Flushable)new Flushable(){

            public void flush() throws IOException {
                throw new RuntimeException();
            }
        });
        SafeTestCase.assertFalse((boolean)flushed);
        final Error thrown = new Error();
        try {
            Safe.flush((Flushable)new Flushable(){

                public void flush() throws IOException {
                    throw thrown;
                }
            });
        }
        catch (Error caught) {
            SafeTestCase.assertSame((Object)thrown, (Object)caught);
        }
    }
}

