/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.plugin.PluginManager;
import org.crsh.plugin.Property;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.vfs.FS;
import org.crsh.vfs.File;
import org.crsh.vfs.Path;
import org.crsh.vfs.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginContext {
    private static final Pattern p = Pattern.compile("(.+)\\.groovy");
    private static final Logger log = Logger.getLogger(PluginContext.class.getName());
    final PluginManager manager;
    private final ClassLoader loader;
    private final String version;
    private final ScheduledExecutorService scanner;
    private final Map<String, Property<?>> properties;
    private final FS cmdFS;
    private final Map<String, Object> attributes;
    private final FS confFS;
    private final ExecutorService executor;
    private volatile List<File> dirs;
    private boolean started;
    private ScheduledFuture scannerFuture;

    public PluginContext(PluginDiscovery discovery, Map<String, Object> attributes, FS cmdFS, FS confFS, ClassLoader loader) throws NullPointerException {
        this(Executors.newFixedThreadPool(20), new ScheduledThreadPoolExecutor(1), discovery, attributes, cmdFS, confFS, loader);
    }

    public PluginContext(ExecutorService executor, ScheduledExecutorService scanner, PluginDiscovery discovery, Map<String, Object> attributes, FS cmdFS, FS confFS, ClassLoader loader) throws NullPointerException {
        if (discovery == null) {
            throw new NullPointerException("No null plugin disocovery accepted");
        }
        if (confFS == null) {
            throw new NullPointerException("No null configuration file system accepted");
        }
        if (cmdFS == null) {
            throw new NullPointerException("No null command file system accepted");
        }
        if (loader == null) {
            throw new NullPointerException();
        }
        if (attributes == null) {
            throw new NullPointerException();
        }
        String version = null;
        try {
            Properties props = new Properties();
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/org.crsh/crsh.shell.core/pom.properties");
            if (in != null) {
                props.load(in);
                version = props.getProperty("version");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not load maven properties", e);
        }
        if (version == null) {
            log.log(Level.WARNING, "No version found will use unknown value instead");
            version = "unknown";
        }
        this.loader = loader;
        this.attributes = attributes;
        this.version = version;
        this.dirs = Collections.emptyList();
        this.cmdFS = cmdFS;
        this.properties = new HashMap();
        this.started = false;
        this.manager = new PluginManager(this, discovery);
        this.confFS = confFS;
        this.executor = Executors.newFixedThreadPool(20);
        this.scanner = scanner;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public <T> T getProperty(PropertyDescriptor<T> desc) throws NullPointerException {
        if (desc == null) {
            throw new NullPointerException();
        }
        return this.getProperty(desc.getName(), desc.getType());
    }

    public <T> T getProperty(String propertyName, Class<T> type) throws NullPointerException {
        PropertyDescriptor descriptor;
        if (propertyName == null) {
            throw new NullPointerException("No null property name accepted");
        }
        if (type == null) {
            throw new NullPointerException("No null property type accepted");
        }
        Property<?> property = this.properties.get(propertyName);
        if (property != null && (descriptor = property.getDescriptor()).getType().isAssignableFrom(type)) {
            return type.cast(property.getValue());
        }
        return null;
    }

    public <T> void setProperty(PropertyDescriptor<T> desc, T value) throws NullPointerException {
        if (desc == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            log.log(Level.FINE, "Removing property " + desc.name);
            this.properties.remove(desc.getName());
        } else {
            Property<T> property = new Property<T>(desc, value);
            log.log(Level.FINE, "Setting property " + desc.name + " to value " + property.getValue());
            this.properties.put(desc.getName(), property);
        }
    }

    public <T> void setProperty(PropertyDescriptor<T> desc, String value) throws NullPointerException, IllegalArgumentException {
        if (desc == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            log.log(Level.FINE, "Removing property " + desc.name);
            this.properties.remove(desc.getName());
        } else {
            Property<T> property = desc.toProperty(value);
            log.log(Level.FINE, "Setting property " + desc.name + " to value " + property.getValue());
            this.properties.put(desc.getName(), property);
        }
    }

    public Resource loadResource(String resourceId, ResourceKind resourceKind) {
        Resource res = null;
        try {
            switch (resourceKind) {
                case LIFECYCLE: {
                    if (!"login".equals(resourceId) && !"logout".equals(resourceId)) break;
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    long timestamp = Long.MIN_VALUE;
                    for (File path : this.dirs) {
                        Resource sub;
                        File f = path.child(resourceId + ".groovy", false);
                        if (f == null || (sub = f.getResource()) == null) continue;
                        buffer.write(sub.getContent());
                        buffer.write(10);
                        timestamp = Math.max(timestamp, sub.getTimestamp());
                    }
                    return new Resource(buffer.toByteArray(), timestamp);
                }
                case COMMAND: {
                    for (File path : this.dirs) {
                        File f = path.child(resourceId + ".groovy", false);
                        if (f == null) continue;
                        res = f.getResource();
                    }
                    break;
                }
                case CONFIG: {
                    String path = "/" + resourceId;
                    File file = this.confFS.get(Path.get(path));
                    if (file == null) break;
                    res = file.getResource();
                }
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not obtain resource " + resourceId, e);
        }
        return res;
    }

    public List<String> listResourceId(ResourceKind kind) {
        switch (kind) {
            case COMMAND: {
                TreeSet<String> all = new TreeSet<String>();
                try {
                    for (File path : this.dirs) {
                        for (File file : path.children()) {
                            String name = file.getName();
                            Matcher matcher = p.matcher(name);
                            if (!matcher.matches()) continue;
                            all.add(matcher.group(1));
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                all.remove("login");
                all.remove("logout");
                return new ArrayList<String>(all);
            }
        }
        return Collections.emptyList();
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public Iterable<CRaSHPlugin<?>> getPlugins() {
        return this.manager.getPlugins();
    }

    public <T> Iterable<T> getPlugins(Class<T> pluginType) {
        return this.manager.getPlugins(pluginType);
    }

    public <T> T getPlugin(Class<T> pluginType) {
        Iterator<T> plugins = this.manager.getPlugins(pluginType).iterator();
        return plugins.hasNext() ? (T)plugins.next() : null;
    }

    public void refresh() {
        try {
            File commands = this.cmdFS.get(Path.get("/"));
            ArrayList<File> newDirs = new ArrayList<File>();
            newDirs.add(commands);
            for (File path : commands.children()) {
                if (!path.isDir()) continue;
                newDirs.add(path);
            }
            this.dirs = newDirs;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    synchronized void start() {
        if (!this.started) {
            Integer refreshRate = this.getProperty(PropertyDescriptor.VFS_REFRESH_PERIOD);
            TimeUnit timeUnit = this.getProperty(PropertyDescriptor.VFS_REFRESH_UNIT);
            if (refreshRate != null && refreshRate > 0) {
                TimeUnit tu = timeUnit != null ? timeUnit : TimeUnit.SECONDS;
                this.scannerFuture = this.scanner.scheduleWithFixedDelay(new Runnable(){

                    public void run() {
                        PluginContext.this.refresh();
                    }
                }, 0L, refreshRate.intValue(), tu);
            }
            this.manager.getPlugins(Object.class);
            this.started = true;
        } else {
            log.log(Level.WARNING, "Attempt to double start");
        }
    }

    synchronized void stop() {
        if (this.started) {
            this.manager.shutdown();
            if (this.scannerFuture != null) {
                this.scannerFuture.cancel(true);
            }
            this.scanner.shutdownNow();
            this.executor.shutdownNow();
        } else {
            log.log(Level.WARNING, "Attempt to stop when stopped");
        }
    }
}

