/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import org.crsh.text.Chunk;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.util.Utils;

public abstract class Style
extends Chunk
implements Serializable {
    public static final Style reset = new Style(){

        public Style merge(Style s) throws NullPointerException {
            if (s == null) {
                throw new NullPointerException();
            }
            return s;
        }

        public String toString() {
            return "Style.Reset[]";
        }

        public void writeAnsiTo(Appendable appendable) throws IOException {
            appendable.append("\u001b[0m");
        }
    };
    private static final Boolean[] BOOLEANS = new Boolean[]{true, false, null};
    private static final Color[] COLORS = Arrays.copyOf(Color.values(), Color.values().length + 1);
    private static final Composite[][][][][] ALL = new Composite[BOOLEANS.length][][][][];

    public static Composite style(Color foreground) {
        return Style.style(null, foreground, null);
    }

    public static Composite style(Color foreground, Color background) {
        return Style.style(null, foreground, background);
    }

    public static Composite style(Decoration decoration, Color foreground, Color background) {
        Boolean bold = null;
        Boolean underline = null;
        Boolean blink = null;
        if (decoration != null) {
            switch (decoration) {
                case bold: {
                    bold = true;
                    break;
                }
                case bold_off: {
                    bold = false;
                    break;
                }
                case underline: {
                    underline = true;
                    break;
                }
                case underline_off: {
                    underline = false;
                    break;
                }
                case blink: {
                    blink = true;
                    break;
                }
                case blink_off: {
                    blink = false;
                }
            }
        }
        return Style.style(bold, underline, blink, foreground, background);
    }

    public static Composite style(Boolean bold, Boolean underline, Boolean blink, Color foreground, Color background) {
        int un;
        int bo;
        int n = bold != null ? (bold.booleanValue() ? 0 : 1) : (bo = 2);
        int n2 = underline != null ? (underline.booleanValue() ? 0 : 1) : (un = 2);
        int bl = blink != null ? (blink.booleanValue() ? 0 : 1) : 2;
        int fg = foreground != null ? foreground.ordinal() : COLORS.length - 1;
        int bg = background != null ? background.ordinal() : COLORS.length - 1;
        return ALL[bo][un][bl][fg][bg];
    }

    public static Composite style() {
        return Style.style(null, null, null);
    }

    public static Composite style(Decoration decoration) {
        return Style.style(decoration, null, null);
    }

    public static Composite style(Decoration decoration, Color foreground) {
        return Style.style(decoration, foreground, null);
    }

    public abstract Style merge(Style var1) throws NullPointerException;

    public CharSequence toAnsiSequence() {
        StringBuilder sb = new StringBuilder();
        try {
            this.writeAnsiTo(sb);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
        return sb.toString();
    }

    public abstract void writeAnsiTo(Appendable var1) throws IOException;

    public abstract String toString();

    static {
        for (int bold = 0; bold < BOOLEANS.length; ++bold) {
            Style.ALL[bold] = new Composite[BOOLEANS.length][][][];
            for (int underline = 0; underline < BOOLEANS.length; ++underline) {
                Style.ALL[bold][underline] = new Composite[BOOLEANS.length][][];
                for (int blink = 0; blink < BOOLEANS.length; ++blink) {
                    Style.ALL[bold][underline][blink] = new Composite[COLORS.length][];
                    for (int foreground = 0; foreground < COLORS.length; ++foreground) {
                        Style.ALL[bold][underline][blink][foreground] = new Composite[COLORS.length];
                        for (int background = 0; background < COLORS.length; ++background) {
                            Style.ALL[bold][underline][blink][foreground][background] = new Composite(BOOLEANS[bold], BOOLEANS[underline], BOOLEANS[blink], COLORS[foreground], COLORS[background]);
                        }
                    }
                }
            }
        }
    }

    public static final class Composite
    extends Style {
        protected final Boolean bold;
        protected final Boolean underline;
        protected final Boolean blink;
        protected final Color foreground;
        protected final Color background;

        private Composite(Boolean bold, Boolean underline, Boolean blink, Color foreground, Color background) {
            this.bold = bold;
            this.underline = underline;
            this.blink = blink;
            this.foreground = foreground;
            this.background = background;
        }

        public Composite fg(Color color) {
            return this.foreground(color);
        }

        public Composite foreground(Color color) {
            return Composite.style(this.bold, this.underline, this.blink, color, this.background);
        }

        public Composite bg(Color value) {
            return this.background(value);
        }

        public Composite background(Color value) {
            return Composite.style(this.bold, this.underline, this.blink, this.foreground, value);
        }

        public Composite bold() {
            return this.bold(true);
        }

        public Composite underline() {
            return this.underline(true);
        }

        public Composite blink() {
            return this.blink(true);
        }

        public Composite bold(Boolean value) {
            return Composite.style(value, this.underline, this.blink, this.foreground, this.background);
        }

        public Composite underline(Boolean value) {
            return Composite.style(this.bold, value, this.blink, this.foreground, this.background);
        }

        public Composite blink(Boolean value) {
            return Composite.style(this.bold, this.underline, value, this.foreground, this.background);
        }

        public Composite decoration(Decoration decoration) {
            if (decoration != null) {
                switch (decoration) {
                    case bold: {
                        return this.bold(true);
                    }
                    case bold_off: {
                        return this.bold(false);
                    }
                    case underline: {
                        return this.underline(true);
                    }
                    case underline_off: {
                        return this.underline(false);
                    }
                    case blink: {
                        return this.blink(true);
                    }
                    case blink_off: {
                        return this.blink(false);
                    }
                }
            }
            return this;
        }

        public Boolean getBold() {
            return this.bold;
        }

        public Boolean getUnderline() {
            return this.underline;
        }

        public Boolean getBlink() {
            return this.blink;
        }

        public Color getForeground() {
            return this.foreground;
        }

        public Color getBackground() {
            return this.background;
        }

        public Style merge(Style s) throws NullPointerException {
            if (s == null) {
                throw new NullPointerException();
            }
            if (s == reset) {
                return reset;
            }
            Composite that = (Composite)s;
            Boolean bold = Utils.notNull(that.getBold(), this.getBold());
            Boolean underline = Utils.notNull(that.getUnderline(), this.getUnderline());
            Boolean blink = Utils.notNull(that.getBlink(), this.getBlink());
            Color foreground = Utils.notNull(that.getForeground(), this.getForeground());
            Color background = Utils.notNull(that.getBackground(), this.getBackground());
            return Composite.style(bold, underline, blink, foreground, background);
        }

        public String toString() {
            return "Style.Composite[bold=" + this.bold + ",underline=" + this.underline + ",blink=" + this.blink + ",background=" + (Object)((Object)this.background) + ",foreground=" + (Object)((Object)this.foreground) + "]";
        }

        private static boolean decoration(Appendable appendable, String on, String off, Boolean value, boolean append) throws IOException {
            if (value != null) {
                if (append) {
                    appendable.append(';');
                } else {
                    appendable.append("\u001b[");
                }
                if (value.booleanValue()) {
                    appendable.append(on);
                } else {
                    appendable.append(off);
                }
                return true;
            }
            return false;
        }

        private static boolean color(Appendable appendable, Color color, char base, boolean append) throws IOException {
            if (color != null) {
                if (append) {
                    appendable.append(';');
                } else {
                    appendable.append("\u001b[");
                }
                appendable.append(base);
                appendable.append(color.c);
                return true;
            }
            return false;
        }

        public void writeAnsiTo(Appendable appendable) throws IOException {
            boolean appended = Composite.decoration(appendable, Decoration.bold.code, Decoration.bold_off.code, this.bold, false);
            appended |= Composite.decoration(appendable, Decoration.underline.code, Decoration.underline_off.code, this.underline, appended);
            appended |= Composite.decoration(appendable, Decoration.blink.code, Decoration.blink_off.code, this.blink, appended);
            appended |= Composite.color(appendable, this.foreground, '3', appended);
            if (appended |= Composite.color(appendable, this.background, '4', appended)) {
                appendable.append("m");
            }
        }
    }
}

