/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.groovy;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.crsh.cli.Argument;

@GroovyASTTransformation(phase=CompilePhase.INSTRUCTION_SELECTION)
public class ArgumentNameTransformer
implements ASTTransformation {
    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        for (ClassNode classNode : source.getAST().getClasses()) {
            for (FieldNode field : classNode.getFields()) {
                String name = field.getName();
                this.handle(name, field);
            }
            for (MethodNode method : classNode.getMethods()) {
                for (Parameter parameter : method.getParameters()) {
                    String name = parameter.getName();
                    this.handle(name, parameter);
                }
            }
        }
    }

    private void handle(String name, AnnotatedNode annotated) {
        for (AnnotationNode ann : annotated.getAnnotations()) {
            Expression expr;
            if (!ann.getClassNode().getName().endsWith(Argument.class.getName()) || (expr = ann.getMember("name")) != null) continue;
            expr = new ConstantExpression(name);
            ann.setMember("name", expr);
        }
    }
}

