/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import org.crsh.text.ui.AbstractRendererTestCase;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.LabelElement;
import org.crsh.text.ui.RowElement;

public class RowRendererTestCase
extends AbstractRendererTestCase {
    public void testRender() throws Exception {
        RowElement row = new RowElement().add(new Element[]{new LabelElement("foo"), new LabelElement("bar")});
        this.assertRender((Element)row, 8, "foobar");
        this.assertRender((Element)row, 7, "foobar");
        this.assertRender((Element)row, 6, "foobar");
        this.assertRender((Element)row, 5, "fooba", "   r ");
        this.assertRender((Element)row, 4, "foob", "   a", "   r");
        this.assertRender((Element)row, 3, "foo");
        this.assertRender((Element)row, 2, "fo", "o ");
        this.assertRender((Element)row, 1, "f", "o", "o");
        this.assertNoRender((Element)row, 0);
    }

    public void testCosmetic() throws Exception {
        RowElement row = new RowElement().add(new Element[]{new LabelElement("foo", 5), new LabelElement("This text is larger to be displayed in a cell of 32", 5)});
        this.assertRender((Element)row, 32, "fooThis text is larger to be dis", "   played in a cell of 32       ");
    }
}

