/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.util.Arrays;
import java.util.Collections;
import org.crsh.command.ScriptException;
import org.crsh.shell.AbstractCommandTestCase;
import org.crsh.shell.Commands;
import org.crsh.shell.ErrorType;
import org.crsh.text.ChunkBuffer;

public class PipeTestCase
extends AbstractCommandTestCase {
    public void testIsPiped() {
        this.lifeCycle.bind("piped", Commands.IsPiped.class);
        this.lifeCycle.bind("produce_command", Commands.ProduceString.class);
        this.lifeCycle.bind("noop", Commands.Noop.class);
        Commands.list.clear();
        PipeTestCase.assertEquals((String)"", (String)this.assertOk("piped"));
        PipeTestCase.assertEquals(Arrays.asList(Boolean.FALSE), Commands.list);
        Commands.list.clear();
        PipeTestCase.assertEquals((String)"", (String)this.assertOk("produce_command | piped"));
        PipeTestCase.assertEquals(Arrays.asList(Boolean.TRUE), Commands.list);
        Commands.list.clear();
        PipeTestCase.assertEquals((String)"", (String)this.assertOk("piped | noop"));
        PipeTestCase.assertEquals(Arrays.asList(Boolean.FALSE), Commands.list);
        this.lifeCycle.bind("inscript", "produce_command piped");
        Commands.list.clear();
        PipeTestCase.assertEquals((String)"", (String)this.assertOk("inscript"));
        PipeTestCase.assertEquals(Arrays.asList(Boolean.TRUE), Commands.list);
    }

    public void testKeepLastPipeContent() throws Exception {
        PipeTestCase.assertEquals((String)"bar", (String)this.assertOk("echo foo | echo bar"));
    }

    public void testFlushInPipe() throws Exception {
        PipeTestCase.assertEquals((String)"juu", (String)this.assertOk("echo -f 1 foo bar | echo juu"));
    }

    public void testProducerUseWriter() throws Exception {
        String cmd = "class foo {\n@Command\npublic void main(org.crsh.command.InvocationContext<Integer> context) {\ncontext.getWriter().print('foo');\n}\n}";
        this.lifeCycle.bind("cmd", cmd);
        PipeTestCase.assertEquals((String)"foo", (String)this.assertOk("cmd"));
    }

    public void testProducerWithFormatter() throws Exception {
        this.lifeCycle.bind("cmd", Commands.ProduceValue.class);
        PipeTestCase.assertEquals((String)"<value>abc</value>              \n", (String)this.assertOk("cmd"));
    }

    public void testLeftShiftOperator() {
        String producer = "class foo {\n@Command\npublic void main(org.crsh.command.InvocationContext<Integer> context) {\ncontext << 'hello';\ncontext << 3;\n}\n}";
        this.lifeCycle.bind("producer", producer);
        this.lifeCycle.bind("consumer", Commands.ConsumeInteger.class);
        Commands.list.clear();
        this.assertOk("producer | consumer");
        PipeTestCase.assertEquals(Arrays.asList(3), Commands.list);
    }

    public void testAdaptToChunk() {
        this.lifeCycle.bind("producer", Commands.ProduceValue.class);
        this.lifeCycle.bind("consumer", Commands.ConsumeChunk.class);
        Commands.list.clear();
        this.assertOk("producer | consumer");
        ChunkBuffer buffer = new ChunkBuffer().append(Commands.list);
        PipeTestCase.assertEquals((String)"<value>abc</value>              \n", (String)buffer.toString());
    }

    public void testLifeCycle() throws Exception {
        String consumer = "class consumer {\n  @Command\n  public org.crsh.command.PipeCommand<Object, Object> main() {\n    return new org.crsh.command.PipeCommand<Object, Object>() {\n      public void open() {\n        org.crsh.shell.Commands.list.add('open');\n      }\n      public void close() {\n        org.crsh.shell.Commands.list.add('close');\n      }\n    };\n  }\n}";
        this.lifeCycle.bind("producer", Commands.Noop.class);
        this.lifeCycle.bind("consumer", consumer);
        Commands.list.clear();
        this.assertOk("producer | consumer");
        PipeTestCase.assertEquals(Arrays.asList("open"), Commands.list);
    }

    public void testPropagateFlush() throws Exception {
        String producer = "class producer {\n  @Command\n  public org.crsh.command.PipeCommand<Object, Object> main() {\n    return new org.crsh.command.PipeCommand<Object, Object>() {\n      public void open() {\n        context.flush();\n      }\n    };\n  }\n}";
        String consumer = "class consumer {\n  @Command\n  public org.crsh.command.PipeCommand<Object, Object> main() {\n    return new org.crsh.command.PipeCommand<Object, Object>() {\n      public void flush() {\n        org.crsh.shell.Commands.list.add('flush');\n      }\n    };\n  }\n}";
        this.lifeCycle.bind("producer", producer);
        this.lifeCycle.bind("consumer", consumer);
        Commands.list.clear();
        this.assertOk("producer | consumer");
        PipeTestCase.assertEquals(Arrays.asList("flush", "flush"), Commands.list);
    }

    public void testProvideInFlush() throws Exception {
        String producer = "class producer {\n  @Command\n  public org.crsh.command.PipeCommand<Object, String> main() {\n    return new org.crsh.command.PipeCommand<Object, String>() {\n      public void flush() {\n        context.provide('foo');\n      }\n    };\n  }\n}";
        this.lifeCycle.bind("producer", producer);
        this.lifeCycle.bind("consumer", Commands.ConsumeString.class);
        Commands.list.clear();
        this.assertOk("producer | consumer");
        PipeTestCase.assertEquals(Arrays.asList("foo"), Commands.list);
    }

    public void testProvideInClose() throws Exception {
        String producer = "class producer {\n  @Command\n  public org.crsh.command.PipeCommand<Object, String> main() {\n    return new org.crsh.command.PipeCommand<Object, String>() {\n      public void close() {\n        context.provide('foo');\n      }\n    };\n  }\n}";
        this.lifeCycle.bind("producer", producer);
        this.lifeCycle.bind("consumer", Commands.ConsumeString.class);
        Commands.list.clear();
        this.assertOk("producer | consumer");
        PipeTestCase.assertEquals(Arrays.asList("foo"), Commands.list);
    }

    public void testNotAssignableType() throws Exception {
        this.lifeCycle.bind("producer", Commands.ProduceInteger.class);
        this.lifeCycle.bind("consumer", Commands.ConsumeBoolean.class);
        Commands.list.clear();
        this.assertOk("producer | consumer");
        PipeTestCase.assertEquals(Collections.emptyList(), Commands.list);
    }

    public void testSameType() throws Exception {
        this.lifeCycle.bind("producer", Commands.ProduceInteger.class);
        this.lifeCycle.bind("consumer", Commands.ConsumeInteger.class);
        Commands.list.clear();
        this.assertOk("producer | consumer");
        PipeTestCase.assertEquals(Arrays.asList(3), Commands.list);
    }

    public void testConsumerThrowsScriptExceptionInProvide() throws Exception {
        String consumer = "class producer {\n  @Command\n  public org.crsh.command.PipeCommand<Integer, Object> main() {\n    return new org.crsh.command.PipeCommand<Integer, Object>() {\n      public void provide(Integer element) {\n        throw new org.crsh.command.ScriptException('foo')\n      }\n    };\n  }\n}\n";
        this.lifeCycle.bind("producer", Commands.ProduceInteger.class);
        this.lifeCycle.bind("consumer", consumer);
        Commands.list.clear();
        Throwable t = this.assertError("producer | consumer", ErrorType.EVALUATION);
        ScriptException ex = PipeTestCase.assertInstance(ScriptException.class, t);
        PipeTestCase.assertEquals((String)"foo", (String)ex.getMessage());
    }

    public void testBuffer() {
        this.lifeCycle.bind("produce_command", Commands.ProduceString.class);
        this.lifeCycle.bind("b", Commands.Buffer.class);
        this.lifeCycle.bind("consume_command", Commands.ConsumeString.class);
        Commands.list.clear();
        this.assertOk("produce_command | consume_command");
        PipeTestCase.assertEquals((int)2, (int)Commands.list.size());
        Commands.list.clear();
        this.assertOk("produce_command | b | consume_command");
        PipeTestCase.assertEquals((int)2, (int)Commands.list.size());
    }

    public void testFilter() {
        this.lifeCycle.bind("produce_command", Commands.ProduceString.class);
        this.lifeCycle.bind("f", Commands.Filter.class);
        this.lifeCycle.bind("consume_command", Commands.ConsumeString.class);
        Commands.list.clear();
        this.assertOk("produce_command | consume_command");
        PipeTestCase.assertEquals((int)2, (int)Commands.list.size());
        Commands.list.clear();
        this.assertOk("produce_command | f | consume_command");
        PipeTestCase.assertEquals((int)2, (int)Commands.list.size());
    }
}

